/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.filebot.util.FileUtilities;

public final class TemporaryFolder {
    private static final Map<String, TemporaryFolder> folders = new HashMap<String, TemporaryFolder>();
    private final File root;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TemporaryFolder getFolder(String name) {
        name = name.toLowerCase();
        Map<String, TemporaryFolder> map = folders;
        synchronized (map) {
            TemporaryFolder folder = folders.get(name);
            if (folder == null) {
                File tmpdir = new File(System.getProperty("java.io.tmpdir"));
                String subdir = String.format("%s [%s]", name, UUID.randomUUID());
                folder = new TemporaryFolder(new File(tmpdir, subdir));
                folders.put(name, folder);
            }
            return folder;
        }
    }

    private TemporaryFolder(File root) {
        this.root = root;
    }

    public File createFile(String name) throws IOException {
        File file = new File(this.getFolder(), name);
        file.createNewFile();
        return file;
    }

    public File createFile(String prefix, String suffix) throws IOException {
        return File.createTempFile(prefix, suffix, this.getFolder());
    }

    public boolean deleteFile(String name) throws IOException {
        return new File(this.getFolder(), name).delete();
    }

    public File getFolder() throws IOException {
        FileUtilities.createFolders(this.root);
        return this.root;
    }

    public TemporaryFolder subFolder(String name) throws IOException {
        return new TemporaryFolder(new File(this.getFolder(), name));
    }

    public List<File> list(boolean recursive) {
        ArrayList<File> list = new ArrayList<File>();
        this.list(this.root, list, recursive);
        return list;
    }

    private void list(File file, List<File> list, boolean recursive) {
        if (file.isDirectory()) {
            for (File entry : FileUtilities.getChildren(file)) {
                if (entry.isDirectory()) {
                    if (!recursive) continue;
                    this.list(entry, list, recursive);
                    continue;
                }
                list.add(entry);
            }
        }
    }

    public void delete() {
        this.delete(this.root);
    }

    private void delete(File file) {
        if (file.isDirectory()) {
            for (File entry : FileUtilities.getChildren(file)) {
                this.delete(entry);
            }
        }
        file.delete();
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread("TemporaryFolder Cleanup"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Map map = folders;
                synchronized (map) {
                    for (TemporaryFolder folder : folders.values()) {
                        folder.delete();
                    }
                }
            }
        });
    }
}

