/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.util.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import net.filebot.util.ui.LinkButton;
import net.miginfocom.swing.MigLayout;

public class ActionPopup
extends JPopupMenu {
    protected final JLabel headerLabel = new JLabel();
    protected final JLabel descriptionLabel = new JLabel();
    protected final JLabel statusLabel = new JLabel();
    protected final JPanel actionPanel = new JPanel(new MigLayout("nogrid, insets 0, fill"));
    private final ActionListener closeListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ActionPopup.this.setVisible(false);
        }
    };

    public ActionPopup(String label, Icon icon) {
        this.headerLabel.setText(label);
        this.headerLabel.setIcon(icon);
        this.headerLabel.setIconTextGap(5);
        this.actionPanel.setOpaque(false);
        this.statusLabel.setFont(this.statusLabel.getFont().deriveFont(10.0f));
        this.statusLabel.setForeground(Color.GRAY);
        this.setLayout(new MigLayout("nogrid, fill, insets 0"));
        this.add((Component)this.headerLabel, "gapx 5px 5px, gapy 3px 1px, wrap 3px");
        this.add((Component)new JSeparator(), "growx, wrap 1px");
        this.add((Component)this.actionPanel, "growx, wrap 0px");
        this.add((Component)new JSeparator(), "growx, wrap 0px");
        this.add((Component)this.statusLabel, "growx, h 11px!, gapx 3px, wrap 1px");
        this.setLightWeightPopupEnabled(false);
    }

    public void addDescription(JComponent component) {
        this.actionPanel.add((Component)component, "gapx 4px, wrap 3px");
    }

    public void addAction(JComponent component) {
        this.actionPanel.add((Component)component, "gapx 12px 12px, growx, wrap");
    }

    @Override
    public void addSeparator() {
        this.actionPanel.add((Component)new JSeparator(), "growx, wrap 1px");
    }

    @Override
    public JMenuItem add(Action a) {
        LinkButton link = new LinkButton(a);
        link.setText(String.format("<html><nobr><u>%s</u></nobr></html>", link.getText()));
        link.setRolloverEnabled(false);
        link.setColor(link.getRolloverColor());
        link.addActionListener(this.closeListener);
        this.addAction(link);
        return null;
    }

    public void clear() {
        this.actionPanel.removeAll();
    }

    @Override
    public void setLabel(String label) {
        this.headerLabel.setText(label);
    }

    @Override
    public String getLabel() {
        return this.headerLabel.getText();
    }

    public void setStatus(String string) {
        this.statusLabel.setText(string);
    }

    public String getStatus() {
        return this.statusLabel.getText();
    }
}

