/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.util.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.border.Border;

public class DashedSeparator
implements Border {
    private final int height;
    private final int dash;
    private final Color foreground;
    private final Color background;

    public DashedSeparator(int height, int dash, Color foreground, Color background) {
        this.height = height;
        this.dash = dash;
        this.foreground = foreground;
        this.background = background;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(0, 0, this.height, 0);
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        Graphics2D g2d = (Graphics2D)g.create(x, h - this.height, w, h);
        g2d.setPaint(this.background);
        g2d.fillRect(0, 0, w, h);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setColor(this.foreground);
        g2d.setStroke(new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{this.dash}, 0.0f));
        g2d.drawLine(this.dash, this.height / 2, w - this.dash, this.height / 2);
        g2d.dispose();
    }
}

