/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.util.ui;

import java.util.function.Consumer;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class LazyDocumentListener
implements DocumentListener {
    private Timer timer;
    private DocumentEvent lastEvent = null;

    public LazyDocumentListener(Consumer<DocumentEvent> handler) {
        this(200, handler);
    }

    public LazyDocumentListener(int delay, Consumer<DocumentEvent> handler) {
        this.timer = new Timer(delay, evt -> {
            handler.accept(this.lastEvent);
            this.lastEvent = null;
        });
        this.timer.setRepeats(false);
    }

    @Override
    public void changedUpdate(DocumentEvent evt) {
        this.lastEvent = evt;
        this.timer.restart();
    }

    @Override
    public void insertUpdate(DocumentEvent evt) {
        this.lastEvent = evt;
        this.timer.restart();
    }

    @Override
    public void removeUpdate(DocumentEvent evt) {
        this.lastEvent = evt;
        this.timer.restart();
    }
}

