/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.util.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.Timer;

public class ProgressIndicator
extends JComponent {
    private float radius = 4.0f;
    private int shapeCount = 3;
    private float strokeWidth = 2.0f;
    private Stroke stroke = new BasicStroke(this.strokeWidth, 0, 1);
    private Color progressShapeColor = Color.orange;
    private Color backgroundShapeColor = new Color(0.0f, 0.0f, 0.0f, 0.25f);
    private final Rectangle2D frame = new Rectangle2D.Double();
    private final Ellipse2D circle = new Ellipse2D.Double();
    private final Dimension baseSize = new Dimension(32, 32);
    private double alpha = 0.0;
    private double speed = 24.0;
    private Timer updateTimer;

    public ProgressIndicator() {
        this.setPreferredSize(this.baseSize);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                ProgressIndicator.this.startAnimation();
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                ProgressIndicator.this.stopAnimation();
            }
        });
    }

    public void animateOnce() {
        double d;
        this.alpha += this.speed / 1000.0;
        if (d >= 1.0) {
            this.alpha -= Math.floor(this.alpha);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        double a = Math.min(this.getWidth(), this.getHeight());
        g2d.scale(a / (double)this.baseSize.width, a / (double)this.baseSize.height);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.frame.setFrame(this.radius, this.radius, (float)this.baseSize.width - this.radius * 2.0f - 1.0f, (float)this.baseSize.height - this.radius * 2.0f - 1.0f);
        this.paintShapes(g2d);
    }

    private void paintShapes(Graphics2D g2d) {
        this.circle.setFrame(this.frame);
        g2d.setStroke(this.stroke);
        g2d.setPaint(this.backgroundShapeColor);
        g2d.draw(this.circle);
        Point2D.Double center = new Point2D.Double(this.frame.getCenterX(), this.frame.getMinY());
        this.circle.setFrameFromCenter(center, new Point2D.Double(((Point2D)center).getX() + (double)this.radius, ((Point2D)center).getY() + (double)this.radius));
        g2d.setStroke(this.stroke);
        g2d.setPaint(this.progressShapeColor);
        g2d.rotate(this.getTheta(this.alpha, 1.0), this.frame.getCenterX(), this.frame.getCenterY());
        double theta = this.getTheta(1.0, this.shapeCount);
        for (int i = 0; i < this.shapeCount; ++i) {
            g2d.rotate(theta, this.frame.getCenterX(), this.frame.getCenterY());
            g2d.fill(this.circle);
        }
    }

    private double getTheta(double value, double max) {
        return value / max * 2.0 * Math.PI;
    }

    public void startAnimation() {
        if (this.updateTimer == null) {
            this.updateTimer = new Timer(20, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ProgressIndicator.this.animateOnce();
                    ProgressIndicator.this.repaint();
                }
            });
            this.updateTimer.start();
        }
    }

    public void stopAnimation() {
        if (this.updateTimer != null) {
            this.updateTimer.stop();
            this.updateTimer = null;
        }
    }

    public void setShapeCount(int indeterminateShapeCount) {
        this.shapeCount = indeterminateShapeCount;
    }

    public void setSpeed(double speed) {
        this.speed = speed;
    }

    public double getSpeed() {
        return this.speed;
    }
}

