/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.util.ui;

import java.util.concurrent.FutureTask;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Level;
import javafx.concurrent.Task;
import javafx.concurrent.Worker;
import javafx.stage.Modality;
import javafx.stage.Stage;
import net.filebot.Logging;
import net.filebot.util.ui.SwingUI;
import org.controlsfx.dialog.ProgressDialog;

public class ProgressMonitor<T> {
    public static <T> FutureTask<T> runTask(String title, String header, final ProgressWorker<T> worker) {
        SwingUI.initJavaFX();
        Task task = new Task<T>(){

            protected T call() throws Exception {
                return worker.call(arg_0 -> (this).updateMessage(arg_0), (arg_0, arg_1) -> (this).updateProgress(arg_0, arg_1), () -> this.isCancelled());
            }
        };
        SwingUI.invokeJavaFX(() -> ProgressMonitor.lambda$runTask$1((Task)task, title, header));
        Thread thread = new Thread((Runnable)task);
        thread.setDaemon(true);
        thread.start();
        return task;
    }

    private ProgressMonitor() {
        throw new UnsupportedOperationException();
    }

    private static /* synthetic */ void lambda$runTask$1(Task task, String title, String header) {
        try {
            ProgressDialog dialog = new ProgressDialog((Worker<?>)task);
            dialog.initModality(Modality.APPLICATION_MODAL);
            dialog.setTitle(title);
            dialog.setHeaderText(header);
            Stage stage = (Stage)dialog.getDialogPane().getScene().getWindow();
            stage.setAlwaysOnTop(true);
            stage.setOnCloseRequest(evt -> task.cancel());
        }
        catch (Exception e) {
            Logging.debug.log(Level.WARNING, e, e::toString);
        }
    }

    @FunctionalInterface
    public static interface ProgressWorker<T> {
        public T call(Consumer<String> var1, BiConsumer<Long, Long> var2, Supplier<Boolean> var3) throws Exception;
    }
}

