/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.util.ui;

import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class PrototypeCellValueUpdater<T>
implements ListDataListener {
    private int longestItemLength = -1;
    private JList<T> list;
    private T defaultValue;

    public PrototypeCellValueUpdater(JList<T> list, T defaultValue) {
        this.list = list;
        this.defaultValue = defaultValue;
    }

    @Override
    public void intervalRemoved(ListDataEvent evt) {
        ListModel m = (ListModel)evt.getSource();
        if (m.getSize() == 0) {
            this.longestItemLength = -1;
            this.list.setPrototypeCellValue(null);
        }
    }

    @Override
    public void intervalAdded(ListDataEvent evt) {
        this.contentsChanged(evt);
    }

    @Override
    public void contentsChanged(ListDataEvent evt) {
        ListModel m = (ListModel)evt.getSource();
        for (int i = evt.getIndex0(); i <= evt.getIndex1() && i < m.getSize(); ++i) {
            Object item = m.getElementAt(i);
            int itemLength = item.toString().length();
            if (itemLength <= this.longestItemLength) continue;
            if (item == this.list.getPrototypeCellValue()) {
                this.list.setPrototypeCellValue(this.defaultValue);
            }
            this.longestItemLength = itemLength;
            this.list.setPrototypeCellValue(item);
        }
    }
}

