/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.util.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultSingleSelectionModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SingleSelectionModel;
import net.filebot.util.ui.GradientStyle;
import net.filebot.util.ui.LabelProvider;
import net.filebot.util.ui.NullLabelProvider;

public class SelectButton<T>
extends JButton {
    public static final String SELECTED_VALUE = "selected value";
    private final Color beginColor = new Color(15789796);
    private final Color endColor = new Color(14737108);
    private final Color beginColorHover = this.beginColor;
    private final Color endColorHover = new Color(14211021);
    private final SelectIcon selectIcon = new SelectIcon();
    private List<T> model = Collections.emptyList();
    private SingleSelectionModel selectionModel = new DefaultSingleSelectionModel();
    private LabelProvider<T> labelProvider = new NullLabelProvider();
    private boolean hover = false;

    public SelectButton() {
        this.setContentAreaFilled(false);
        this.setFocusable(false);
        super.setIcon(this.selectIcon);
        this.setHorizontalAlignment(0);
        this.setVerticalAlignment(0);
        this.setBorder(BorderFactory.createLineBorder(new Color(0xA4A4A4), 1));
        this.setPreferredSize(new Dimension(32, 22));
        this.addActionListener(new OpenPopupOnClick());
    }

    public void setModel(Collection<T> model) {
        this.model = new ArrayList<T>(model);
        this.setSelectedIndex(0);
    }

    public LabelProvider<T> getLabelProvider() {
        return this.labelProvider;
    }

    public void setLabelProvider(LabelProvider<T> labelProvider) {
        this.labelProvider = labelProvider;
        this.setIcon(labelProvider.getIcon(this.getSelectedValue()));
    }

    @Override
    public void setIcon(Icon icon) {
        this.selectIcon.setInnerIcon(icon);
        this.repaint();
    }

    public void setSelectedValue(T value) {
        this.setSelectedIndex(this.model.indexOf(value));
    }

    public T getSelectedValue() {
        if (!this.selectionModel.isSelected()) {
            return null;
        }
        return this.model.get(this.selectionModel.getSelectedIndex());
    }

    public void setSelectedIndex(int i) {
        if (i < 0 || i >= this.model.size()) {
            this.selectionModel.clearSelection();
            this.setIcon(null);
            return;
        }
        this.selectionModel.setSelectedIndex(i);
        T value = this.model.get(i);
        this.setIcon(this.labelProvider.getIcon(value));
        this.firePropertyChange(SELECTED_VALUE, null, value);
    }

    public int getSelectedIndex() {
        return this.selectionModel.getSelectedIndex();
    }

    public SingleSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void spinValue(int spin) {
        int size = this.model.size();
        int next = this.getSelectedIndex() + (spin %= size);
        if (next < 0) {
            next += size;
        } else if (next >= size) {
            next -= size;
        }
        this.setSelectedIndex(next);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        Rectangle bounds = new Rectangle(this.getSize());
        if (this.hover) {
            g2d.setPaint(GradientStyle.TOP_TO_BOTTOM.getGradientPaint(bounds, this.beginColorHover, this.endColorHover));
        } else {
            g2d.setPaint(GradientStyle.TOP_TO_BOTTOM.getGradientPaint(bounds, this.beginColor, this.endColor));
        }
        g2d.fill(bounds);
        super.paintComponent(g);
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        switch (e.getID()) {
            case 504: {
                this.hover = true;
                this.repaint();
                break;
            }
            case 505: {
                this.hover = false;
                this.repaint();
            }
        }
        super.processMouseEvent(e);
    }

    private static class SelectIcon
    implements Icon {
        private final GeneralPath arrow = new GeneralPath(0, 3);
        private Icon icon;

        public SelectIcon() {
            int x = 25;
            int y = 10;
            this.arrow.moveTo(x - 2, y);
            this.arrow.lineTo(x, y + 3);
            this.arrow.lineTo(x + 3, y);
            this.arrow.lineTo(x - 2, y);
        }

        public void setInnerIcon(Icon icon) {
            this.icon = icon;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2d = (Graphics2D)g;
            if (this.icon != null) {
                this.icon.paintIcon(c, g2d, 4, 3);
            }
            g2d.setPaint(Color.BLACK);
            g2d.fill(this.arrow);
        }

        @Override
        public int getIconWidth() {
            return 30;
        }

        @Override
        public int getIconHeight() {
            return 20;
        }
    }

    private class SelectPopupMenuItem
    extends JMenuItem
    implements ActionListener {
        private final T value;

        public SelectPopupMenuItem(String text, Icon icon, T value) {
            super(text, icon);
            this.value = value;
            this.setMargin(new Insets(3, 0, 3, 0));
            this.addActionListener(this);
        }

        @Override
        public void setSelected(boolean selected) {
            this.setFont(this.getFont().deriveFont(selected ? 1 : 0));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SelectButton.this.setSelectedValue(this.value);
        }
    }

    private class OpenPopupOnClick
    implements ActionListener {
        private OpenPopupOnClick() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JPopupMenu popup = new JPopupMenu();
            for (Object value : SelectButton.this.model) {
                SelectPopupMenuItem item = new SelectPopupMenuItem(SelectButton.this.labelProvider.getText(value), SelectButton.this.labelProvider.getIcon(value), value);
                if (value == SelectButton.this.getSelectedValue()) {
                    item.setSelected(true);
                }
                popup.add(item);
            }
            popup.show(SelectButton.this, 0, SelectButton.this.getHeight() - 1);
        }
    }
}

