/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.util.ui;

import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.SubscriberExceptionContext;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import net.filebot.Logging;

public class SwingEventBus
extends AsyncEventBus {
    private static SwingEventBus instance;

    public static synchronized SwingEventBus getInstance() {
        if (instance == null) {
            instance = new SwingEventBus();
        }
        return instance;
    }

    public SwingEventBus() {
        super(SwingUtilities::invokeLater, SwingEventBus::handleException);
    }

    @Override
    public void register(Object object) {
        SwingUtilities.invokeLater(() -> super.register(object));
    }

    @Override
    public void unregister(Object object) {
        SwingUtilities.invokeLater(() -> super.unregister(object));
    }

    @Override
    public void post(Object object) {
        SwingUtilities.invokeLater(() -> super.post(object));
    }

    protected static void handleException(Throwable throwable, SubscriberExceptionContext context) {
        Logging.debug.log(Level.WARNING, "Failed to handle event: " + context.getEvent(), throwable);
    }
}

