/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.util.ui.notification;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Window;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.border.Border;
import net.filebot.util.ui.SwingUI;
import net.filebot.util.ui.notification.NotificationWindow;

public class MessageNotification
extends NotificationWindow {
    private int margin = 10;
    private Border marginBorder = BorderFactory.createEmptyBorder(this.margin, this.margin, this.margin, this.margin);
    private Border border = BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(new Color(245, 155, 15), Color.WHITE), this.marginBorder);
    private JLabel headLabel;
    private JTextPane textArea;
    private JLabel imageLabel;

    public MessageNotification(String head, String text, Icon icon, int timeout) {
        this(null, head, text, icon, timeout);
    }

    public MessageNotification(String head, String text, Icon icon) {
        this(head, text, icon, -1);
    }

    public MessageNotification(Window owner, String head, String text, Icon icon, int timeout) {
        super(owner, timeout);
        JComponent c = (JComponent)this.getContentPane();
        c.setLayout(new BorderLayout(5, 2));
        c.setBackground(Color.WHITE);
        c.setBorder(this.border);
        JPanel textPanel = new JPanel(new BorderLayout());
        textPanel.setOpaque(false);
        textPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.headLabel = new JLabel(head);
        this.headLabel.setHorizontalAlignment(0);
        this.headLabel.setFont(this.headLabel.getFont().deriveFont(1));
        textPanel.add((Component)this.headLabel, "North");
        this.textArea = new JTextPane();
        this.textArea.setText(text);
        this.textArea.setEditable(false);
        this.textArea.setOpaque(false);
        textPanel.add((Component)this.textArea, "Center");
        if (icon != null) {
            this.imageLabel = new JLabel(icon);
            c.add((Component)this.imageLabel, "West");
        }
        c.add((Component)textPanel, "Center");
        this.pack();
        this.getGlassPane().setCursor(Cursor.getPredefinedCursor(12));
        this.getGlassPane().addMouseListener(SwingUI.mouseClicked(evt -> SwingUI.copyToClipboard(text)));
    }
}

