/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.util.ui.notification;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import net.filebot.util.ui.SwingUI;
import net.filebot.util.ui.notification.NotificationLayout;
import net.filebot.util.ui.notification.NotificationWindow;
import net.filebot.util.ui.notification.QueueNotificationLayout;

public class NotificationManager {
    private final NotificationLayout layout;
    private final int limit;

    public NotificationManager() {
        this(new QueueNotificationLayout(), 5);
    }

    public NotificationManager(NotificationLayout layout, int limit) {
        this.layout = layout;
        this.limit = limit;
    }

    public void show(NotificationWindow notification) {
        SwingUI.checkEventDispatchThread();
        if (this.layout.size() < this.limit) {
            this.layout.add(notification);
            notification.addWindowListener(new RemoveListener());
            notification.setVisible(true);
        }
    }

    private class RemoveListener
    extends WindowAdapter {
        private RemoveListener() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            NotificationManager.this.layout.remove((NotificationWindow)e.getWindow());
        }
    }
}

