/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.util.ui.notification;

import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import javax.swing.JWindow;
import javax.swing.Timer;
import net.filebot.util.ui.SwingUI;

public class NotificationWindow
extends JWindow {
    private final int timeout;
    private final ComponentListener closeOnTimeout = new ComponentAdapter(){
        private Timer timer = null;

        @Override
        public void componentShown(ComponentEvent e) {
            if (NotificationWindow.this.timeout >= 0) {
                this.timer = SwingUI.invokeLater(NotificationWindow.this.timeout, () -> NotificationWindow.this.close());
            }
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            if (this.timer != null) {
                this.timer.stop();
            }
        }
    };

    public NotificationWindow(Window owner, int timeout) {
        this(owner, timeout, true);
    }

    public NotificationWindow(Window owner, int timeout, boolean closeOnClick) {
        super(owner);
        this.timeout = timeout;
        this.setAlwaysOnTop(true);
        if (closeOnClick) {
            this.getGlassPane().addMouseListener(SwingUI.mouseClicked(evt -> this.close()));
            this.getGlassPane().setVisible(true);
        }
        this.addComponentListener(this.closeOnTimeout);
    }

    public NotificationWindow(Window owner) {
        this(owner, -1);
    }

    public final void close() {
        SwingUI.checkEventDispatchThread();
        this.processWindowEvent(new WindowEvent(this, 201));
        this.setVisible(false);
        this.processComponentEvent(new ComponentEvent(this, 103));
        this.dispose();
    }
}

