/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.util.ui.notification;

import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.filebot.util.ui.notification.Direction;
import net.filebot.util.ui.notification.NotificationLayout;
import net.filebot.util.ui.notification.NotificationWindow;

public class QueueNotificationLayout
implements NotificationLayout {
    private final List<NotificationWindow> notifications = new ArrayList<NotificationWindow>();
    private final Direction alignment;
    private final Direction direction;
    private final Direction growAnchor;

    public QueueNotificationLayout() {
        this(Direction.SOUTH_EAST, Direction.WEST);
    }

    public QueueNotificationLayout(Direction alignment, Direction direction) {
        this.alignment = alignment;
        this.growAnchor = alignment;
        this.direction = direction;
    }

    public QueueNotificationLayout(Direction orientation, Direction direction, Direction growAnchor) {
        this.alignment = orientation;
        this.direction = direction;
        this.growAnchor = growAnchor;
    }

    private Point getBaseAnchor(Dimension screen, Insets insets) {
        Point p = new Point();
        screen.height -= insets.top + insets.bottom;
        screen.width -= insets.left + insets.right;
        p.x = (int)(this.alignment.ax * (double)screen.width);
        p.y = (int)(this.alignment.ay * (double)screen.height);
        p.x += insets.left;
        p.y += insets.top;
        return p;
    }

    private Point getLocation(Point anchor, Dimension size) {
        Point p = new Point();
        p.x = (int)((double)anchor.x - (double)size.width * this.growAnchor.ax);
        p.y = (int)((double)anchor.y - (double)size.height * this.growAnchor.ay);
        return p;
    }

    private Point getNextAnchor(Point anchor, Dimension size) {
        Point p = new Point();
        p.x = anchor.x + size.width * this.direction.vx;
        p.y = anchor.y + size.height * this.direction.vy;
        return p;
    }

    @Override
    public void add(NotificationWindow notification) {
        this.notifications.add(notification);
        this.align(notification.getGraphicsConfiguration());
    }

    private void align(GraphicsConfiguration gc) {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(gc);
        Point anchor = this.getBaseAnchor(screen, insets);
        this.align(anchor, screen, this.notifications.iterator());
    }

    private void align(Point anchor, Dimension screen, Iterator<NotificationWindow> seq) {
        if (!seq.hasNext()) {
            return;
        }
        NotificationWindow window = seq.next();
        Dimension size = window.getSize();
        size.width = Math.min(size.width, (int)((double)screen.width * 0.8));
        size.height = Math.min(size.height, (int)((double)screen.height * 0.2));
        Point p = this.getLocation(anchor, size);
        this.align(this.getNextAnchor(anchor, size), screen, seq);
        window.setBounds(p.x, p.y, size.width, size.height);
    }

    @Override
    public void remove(NotificationWindow notification) {
        if (this.notifications.remove(notification)) {
            this.align(notification.getGraphicsConfiguration());
        }
    }

    @Override
    public int size() {
        return this.notifications.size();
    }
}

