/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.vfs;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.filebot.util.ByteBufferInputStream;
import net.filebot.util.ByteBufferOutputStream;
import net.filebot.vfs.MemoryFile;

public class ZipArchive
implements Iterable<MemoryFile> {
    private final ByteBuffer data;

    public ZipArchive(ByteBuffer data) {
        this.data = data.duplicate();
    }

    @Override
    public Iterator<MemoryFile> iterator() {
        try {
            return this.extract().iterator();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MemoryFile> extract() throws IOException {
        ArrayList<MemoryFile> vfs = new ArrayList<MemoryFile>();
        try (ZipInputStream zipInputStream = new ZipInputStream(new ByteBufferInputStream(this.data.duplicate()));){
            ZipEntry zipEntry;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (zipEntry.isDirectory()) continue;
                ByteBufferOutputStream buffer = new ByteBufferOutputStream((int)zipEntry.getSize());
                buffer.transferFully(zipInputStream);
                vfs.add(new MemoryFile(zipEntry.getName(), buffer.getByteBuffer()));
            }
        }
        return vfs;
    }
}

