/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.web;

import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Collection;
import java.util.Objects;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.filebot.similarity.Normalization;
import net.filebot.web.Episode;
import net.filebot.web.MultiEpisode;
import net.filebot.web.SimpleDate;

public class EpisodeFormat
extends Format {
    public static final EpisodeFormat SeasonEpisode = new EpisodeFormat();
    private final Pattern sxePattern = Pattern.compile("- (?:(\\d{1,2})x)?(Special )?(\\d{1,3}) -");
    private final Pattern airdatePattern = Pattern.compile("\\[(\\d{4}-\\d{1,2}-\\d{1,2})\\]");

    @Override
    public StringBuffer format(Object obj, StringBuffer sb, FieldPosition pos) {
        if (obj instanceof MultiEpisode) {
            return sb.append(this.formatMultiEpisode(((MultiEpisode)obj).getEpisodes()));
        }
        Episode episode = (Episode)obj;
        String episodeNumber = episode.getEpisode() != null ? String.format("%02d", episode.getEpisode()) : null;
        sb.append(episode.getSeriesName());
        if (episode.getSeason() != null) {
            sb.append(" - ").append(episode.getSeason()).append('x');
            if (episode.getEpisode() != null) {
                sb.append(String.format("%02d", episode.getEpisode()));
            } else if (episode.getSpecial() != null) {
                sb.append("Special " + episode.getSpecial());
            }
        } else if (episode.getEpisode() != null) {
            sb.append(" - ").append(episodeNumber);
        } else if (episode.getSpecial() != null) {
            sb.append(" - ").append("Special " + episode.getSpecial());
        }
        sb.append(" - ").append(episode.getTitle());
        return sb;
    }

    public String formatMultiEpisode(Collection<Episode> episodes) {
        Function<Episode, String> seriesName = it -> it.getSeriesName();
        Function<Episode, String> episodeNumber = it -> this.formatSxE((Episode)it);
        Function<Episode, String> episodeTitle = it -> it.getTitle() == null ? "" : Normalization.removeTrailingBrackets(it.getTitle());
        return Stream.of(seriesName, episodeNumber, episodeTitle).map(f -> episodes.stream().map(f::apply).filter(s -> s.length() > 0).distinct().collect(Collectors.joining(" & "))).collect(Collectors.joining(" - "));
    }

    public String formatSxE(Episode episode) {
        if (episode instanceof MultiEpisode) {
            return this.formatMultiRangeSxE(((MultiEpisode)episode).getEpisodes());
        }
        StringBuilder sb = new StringBuilder();
        if (episode.getSeason() != null || episode.getSpecial() != null) {
            sb.append(episode.getSpecial() == null ? episode.getSeason() : 0).append('x');
        }
        if (episode.getEpisode() != null || episode.getSpecial() != null) {
            sb.append(String.format("%02d", episode.getSpecial() == null ? episode.getEpisode() : episode.getSpecial()));
        }
        return sb.toString();
    }

    public String formatS00E00(Episode episode) {
        if (episode instanceof MultiEpisode) {
            return this.formatMultiRangeS00E00(((MultiEpisode)episode).getEpisodes());
        }
        StringBuilder sb = new StringBuilder();
        if (episode.getSeason() != null || episode.getSpecial() != null) {
            sb.append(String.format("S%02d", episode.getSpecial() == null ? episode.getSeason() : 0));
        }
        if (episode.getEpisode() != null || episode.getSpecial() != null) {
            sb.append(String.format("E%02d", episode.getSpecial() == null ? episode.getEpisode() : episode.getSpecial()));
        }
        return sb.toString();
    }

    public String formatMultiTitle(Collection<Episode> episodes) {
        return episodes.stream().map(Episode::getTitle).filter(Objects::nonNull).map(Normalization::removeTrailingBrackets).distinct().collect(Collectors.joining(" & "));
    }

    public String formatMultiRangeSxE(Iterable<Episode> episodes) {
        return this.formatMultiRangeNumbers(episodes, "%01dx", "%02d");
    }

    public String formatMultiRangeS00E00(Iterable<Episode> episodes) {
        return this.formatMultiRangeNumbers(episodes, "S%02d", "E%02d");
    }

    public String formatMultiRangeNumbers(Iterable<Episode> episodes, String seasonFormat, String episodeFormat) {
        return this.getSeasonEpisodeNumbers(episodes).entrySet().stream().map(it -> {
            String s = (Integer)it.getKey() >= 0 ? String.format(seasonFormat, it.getKey()) : "";
            return Stream.of((Integer)((SortedSet)it.getValue()).first(), (Integer)((SortedSet)it.getValue()).last()).distinct().map(i -> String.format(episodeFormat, i)).collect(Collectors.joining("-", s, ""));
        }).collect(Collectors.joining(" - "));
    }

    private SortedMap<Integer, SortedSet<Integer>> getSeasonEpisodeNumbers(Iterable<Episode> episodes) {
        TreeMap<Integer, SortedSet<Integer>> n = new TreeMap<Integer, SortedSet<Integer>>();
        for (Episode it : episodes) {
            Integer s = it.getSeason() == null || it.getSpecial() != null ? (it.getSpecial() == null ? -1 : 0) : it.getSeason();
            Integer e = it.getEpisode() == null ? (it.getSpecial() == null ? -1 : it.getSpecial()) : it.getEpisode();
            n.computeIfAbsent(s, key -> new TreeSet()).add(e);
        }
        return n;
    }

    @Override
    public Episode parseObject(String s, ParsePosition pos) {
        StringBuilder source = new StringBuilder(s);
        Integer season = null;
        Integer episode = null;
        Integer special = null;
        SimpleDate airdate = null;
        Matcher m = this.airdatePattern.matcher(source);
        if (m.find()) {
            airdate = SimpleDate.parse(m.group(1));
            source.replace(m.start(), m.end(), "");
        }
        if ((m = this.sxePattern.matcher(source)).find()) {
            Integer n = season = m.group(1) == null ? null : new Integer(m.group(1));
            if (m.group(2) == null) {
                episode = new Integer(m.group(3));
            } else {
                special = new Integer(m.group(3));
            }
            source.replace(m.start(), m.end(), "");
            String name = source.substring(0, m.start()).trim();
            String title = source.substring(m.start()).trim();
            pos.setIndex(source.length());
            return new Episode(name, season, episode, title, season == null ? episode : null, special, airdate, null, null);
        }
        pos.setErrorIndex(0);
        return null;
    }

    @Override
    public Episode parseObject(String source) throws ParseException {
        return (Episode)super.parseObject(source);
    }
}

