/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.web;

import com.ibm.icu.text.Transliterator;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.filebot.similarity.Normalization;
import uk.ac.shef.wit.simmetrics.similaritymetrics.AbstractStringMetric;
import uk.ac.shef.wit.simmetrics.similaritymetrics.QGramsDistance;

public class LocalSearch<T> {
    private AbstractStringMetric metric = new QGramsDistance();
    private float resultMinimumSimilarity = 0.5f;
    private int resultSetSize = 20;
    private Transliterator transliterator = Transliterator.getInstance("Any-Latin;Latin-ASCII;[:Diacritic:]remove");
    private T[] objects;
    private Set<String>[] fields;

    public LocalSearch(T[] data, Function<T, Collection<String>> keywords) {
        this.objects = (Object[])data.clone();
        this.fields = (Set[])Arrays.stream(this.objects).map(keywords).map(this::normalize).toArray(Set[]::new);
    }

    public List<T> search(String q) throws ExecutionException, InterruptedException {
        String query = this.normalize(q);
        return IntStream.range(0, this.objects.length).mapToObj(i -> {
            T object = this.objects[i];
            Set<String> field = this.fields[i];
            boolean match = field.stream().anyMatch(it -> it.contains(query));
            double similarity = field.stream().mapToDouble(it -> this.metric.getSimilarity(query, (String)it)).max().orElse(0.0);
            return match || similarity > (double)this.resultMinimumSimilarity ? new AbstractMap.SimpleImmutableEntry<T, Double>(object, similarity) : null;
        }).filter(Objects::nonNull).sorted(Collections.reverseOrder(Comparator.comparing(Map.Entry::getValue))).limit(this.resultSetSize).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public void setResultMinimumSimilarity(float resultMinimumSimilarity) {
        this.resultMinimumSimilarity = resultMinimumSimilarity;
    }

    public void setResultSetSize(int resultSetSize) {
        this.resultSetSize = resultSetSize;
    }

    protected Set<String> normalize(Collection<String> values) {
        return values.stream().map(this::normalize).collect(Collectors.toSet());
    }

    protected String normalize(String value) {
        return Normalization.normalizePunctuation(this.transliterator.transform(value)).toLowerCase();
    }
}

