/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.web;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.filebot.web.Episode;
import net.filebot.web.EpisodeFormat;
import net.filebot.web.SeriesInfo;
import net.filebot.web.SimpleDate;

public class MultiEpisode
extends Episode {
    protected Episode[] episodes;

    public MultiEpisode() {
    }

    public MultiEpisode(Episode ... episodes) {
        this.episodes = (Episode[])episodes.clone();
    }

    public MultiEpisode(List<Episode> episodes) {
        this.episodes = episodes.toArray(new Episode[0]);
    }

    public List<Episode> getEpisodes() {
        return Collections.unmodifiableList(Arrays.asList(this.episodes));
    }

    @Override
    public String getSeriesName() {
        return this.episodes[0].getSeriesName();
    }

    @Override
    public Integer getEpisode() {
        return this.episodes[0].getEpisode();
    }

    @Override
    public Integer getSeason() {
        return this.episodes[0].getSeason();
    }

    @Override
    public String getTitle() {
        return EpisodeFormat.SeasonEpisode.formatMultiTitle(this.getEpisodes());
    }

    @Override
    public Integer getAbsolute() {
        return this.episodes[0].getAbsolute();
    }

    @Override
    public Integer getSpecial() {
        return this.episodes[0].getSpecial();
    }

    @Override
    public SimpleDate getAirdate() {
        return this.episodes[0].getAirdate();
    }

    @Override
    public Integer getId() {
        return this.episodes[0].getId();
    }

    @Override
    public SeriesInfo getSeriesInfo() {
        return this.episodes[0].getSeriesInfo();
    }

    @Override
    public List<Integer> getNumbers() {
        return Arrays.stream(this.episodes).flatMap(e -> e.getNumbers().stream()).collect(Collectors.toList());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof MultiEpisode) {
            MultiEpisode other = (MultiEpisode)obj;
            return Arrays.equals(this.episodes, other.episodes);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.episodes);
    }

    @Override
    public MultiEpisode clone() {
        return new MultiEpisode(this.episodes);
    }

    @Override
    public String toString() {
        return EpisodeFormat.SeasonEpisode.formatMultiEpisode(this.getEpisodes());
    }
}

