/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.web;

import java.net.URL;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.Icon;
import net.filebot.Cache;
import net.filebot.CacheType;
import net.filebot.CachedResource;
import net.filebot.Logging;
import net.filebot.ResourceManager;
import net.filebot.util.JsonUtilities;
import net.filebot.util.StringUtilities;
import net.filebot.web.FloodLimit;
import net.filebot.web.Movie;
import net.filebot.web.MovieIdentificationService;
import net.filebot.web.MovieInfo;
import net.filebot.web.Person;
import net.filebot.web.SimpleDate;
import net.filebot.web.WebRequest;

public class OMDbClient
implements MovieIdentificationService {
    private static final FloodLimit REQUEST_LIMIT = new FloodLimit(2, 1L, TimeUnit.SECONDS);

    @Override
    public String getIdentifier() {
        return "OMDb";
    }

    @Override
    public Icon getIcon() {
        return ResourceManager.getIcon("search.omdb");
    }

    protected int getImdbId(String link) {
        Matcher matcher = Pattern.compile("tt(\\d{7})").matcher(link);
        if (matcher.find()) {
            return Integer.parseInt(matcher.group(1));
        }
        throw new IllegalArgumentException(String.format("Cannot find imdb id: %s", link));
    }

    @Override
    public List<Movie> searchMovie(String query, Locale locale) throws Exception {
        Matcher nameYear = Pattern.compile("(.+)\\b(19\\d{2}|20\\d{2})$").matcher(query);
        if (nameYear.matches()) {
            return this.searchMovie(nameYear.group(1).trim(), Integer.parseInt(nameYear.group(2)));
        }
        return this.searchMovie(query, -1);
    }

    public List<Movie> searchMovie(String movieName, int movieYear) throws Exception {
        LinkedHashMap<String, Object> param = new LinkedHashMap<String, Object>(2);
        param.put("s", movieName);
        if (movieYear > 0) {
            param.put("y", movieYear);
        }
        Object response = this.request(param);
        ArrayList<Movie> result = new ArrayList<Movie>();
        for (Object it : JsonUtilities.getArray(response, "Search")) {
            Map<String, String> info = this.getInfoMap(it);
            if (!"movie".equals(info.get("Type"))) continue;
            result.add(this.getMovie(info));
        }
        return result;
    }

    @Override
    public Movie getMovieDescriptor(Movie id, Locale locale) throws Exception {
        if (id.getImdbId() <= 0) {
            throw new IllegalArgumentException("Illegal ID: " + id.getImdbId());
        }
        return this.getMovie(this.getMovieInfo(id.getImdbId(), null, null, false));
    }

    public Map<String, String> getInfoMap(Object node) {
        TreeMap<String, String> info = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        if (node instanceof Map) {
            for (Map.Entry it : ((Map)node).entrySet()) {
                if (it.getKey() == null || it.getValue() == null) continue;
                info.put(it.getKey().toString().trim(), it.getValue().toString().trim());
            }
        }
        return info;
    }

    public Movie getMovie(Map<String, String> info) {
        try {
            String name = info.get("Title");
            int year = StringUtilities.matchInteger(info.get("Year"));
            int imdbid = Integer.parseInt(info.get("imdbID").replace("tt", ""));
            if (name.length() <= 0 || year <= 1900 || imdbid <= 0) {
                throw new IllegalArgumentException();
            }
            return new Movie(name, year, imdbid);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Illegal fields: " + info);
        }
    }

    public Object request(Map<String, Object> parameters) throws Exception {
        Cache cache = Cache.getCache(this.getName(), CacheType.Monthly);
        String key = '?' + WebRequest.encodeParameters(parameters, true);
        return cache.json(key, s -> this.getResource((String)s)).fetch(CachedResource.withPermit(CachedResource.fetchIfModified(), r -> REQUEST_LIMIT.acquirePermit())).expire(Cache.ONE_WEEK).get();
    }

    public URL getResource(String file) throws Exception {
        return new URL("http://www.omdbapi.com/" + file);
    }

    public Map<String, String> getMovieInfo(Integer i, String t, String y, boolean tomatoes) throws Exception {
        LinkedHashMap<String, Object> param = new LinkedHashMap<String, Object>(2);
        if (i != null) {
            param.put("i", String.format("tt%07d", i));
        }
        if (t != null) {
            param.put("t", t);
        }
        if (y != null) {
            param.put("y", y);
        }
        param.put("tomatoes", String.valueOf(tomatoes));
        return this.getInfoMap(this.request(param));
    }

    public MovieInfo getMovieInfo(Movie movie) throws Exception {
        Map<String, String> data;
        Map<String, String> map = data = movie.getImdbId() > 0 ? this.getMovieInfo(movie.getImdbId(), null, null, false) : this.getMovieInfo(null, movie.getName(), String.valueOf(movie.getYear()), false);
        if (!Boolean.parseBoolean(data.get("response"))) {
            throw new IllegalArgumentException("Movie not found: " + data);
        }
        EnumMap<MovieInfo.Property, String> fields = new EnumMap<MovieInfo.Property, String>(MovieInfo.Property.class);
        fields.put(MovieInfo.Property.title, data.get("title"));
        fields.put(MovieInfo.Property.certification, data.get("rated"));
        fields.put(MovieInfo.Property.runtime, this.getRuntimeMinutes(data.get("runtime")));
        fields.put(MovieInfo.Property.tagline, data.get("plot"));
        fields.put(MovieInfo.Property.vote_average, data.get("imdbRating"));
        fields.put(MovieInfo.Property.vote_count, data.get("imdbVotes").replaceAll("\\D", ""));
        fields.put(MovieInfo.Property.imdb_id, data.get("imdbID"));
        fields.put(MovieInfo.Property.poster_path, data.get("poster"));
        SimpleDate release = this.parsePartialDate(data.get("released"), "d MMM yyyy");
        if (release == null) {
            release = this.parsePartialDate(data.get("released"), "yyyy");
        }
        if (release != null) {
            fields.put(MovieInfo.Property.release_date, release.toString());
        }
        Pattern delim = Pattern.compile(",");
        List<String> genres = this.split(delim, data.get("genre"), String::toString);
        List<String> languages = this.split(delim, data.get("language"), String::toString);
        ArrayList<Person> actors = new ArrayList<Person>();
        actors.addAll(this.split(delim, data.get("actors"), s -> new Person((String)s, "Actor")));
        actors.addAll(this.split(delim, data.get("director"), s -> new Person((String)s, "Director")));
        actors.addAll(this.split(delim, data.get("writer"), s -> new Person((String)s, "Writer")));
        return new MovieInfo(fields, Collections.emptyList(), genres, Collections.emptyMap(), languages, Collections.emptyList(), Collections.emptyList(), actors, Collections.emptyList());
    }

    private String getRuntimeMinutes(String runtime) {
        List<Integer> n = StringUtilities.matchIntegers(runtime);
        switch (n.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return Integer.toString(n.get(0));
            }
        }
        return Integer.toString(n.get(0) * 60 + n.get(1));
    }

    private SimpleDate parsePartialDate(String value, String format) {
        if (value != null && value.length() > 0) {
            try {
                TemporalAccessor f = DateTimeFormatter.ofPattern(format, Locale.ENGLISH).parse(value);
                if (f.isSupported(ChronoField.YEAR)) {
                    if (f.isSupported(ChronoField.MONTH_OF_YEAR) && f.isSupported(ChronoField.DAY_OF_MONTH)) {
                        return new SimpleDate(f.get(ChronoField.YEAR), f.get(ChronoField.MONTH_OF_YEAR), f.get(ChronoField.DAY_OF_MONTH));
                    }
                    return new SimpleDate(f.get(ChronoField.YEAR), 1, 1);
                }
            }
            catch (DateTimeParseException e) {
                Logging.debug.warning(Logging.format("Bad date: %s =~ %s => %s", value, format, e));
            }
        }
        return null;
    }

    private <T> List<T> split(Pattern regex, String value, Function<String, T> toObject) {
        if (value == null || value.isEmpty()) {
            return Collections.emptyList();
        }
        return regex.splitAsStream(value).map(String::trim).filter(s -> !s.isEmpty() && !s.equals("N/A")).map(toObject).collect(Collectors.toList());
    }
}

