/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.web;

import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SimpleDate
implements Serializable,
Comparable<Object> {
    protected int year;
    protected int month;
    protected int day;
    public static final Pattern DATE_FORMAT = Pattern.compile("(\\d{4})\\D(\\d{1,2})\\D(\\d{1,2})");

    public SimpleDate() {
    }

    public SimpleDate(int year, int month, int day) {
        this.year = year;
        this.month = month;
        this.day = day;
    }

    public SimpleDate(Temporal date) {
        this(date.get(ChronoField.YEAR), date.get(ChronoField.MONTH_OF_YEAR), date.get(ChronoField.DAY_OF_MONTH));
    }

    public SimpleDate(long t) {
        this(Instant.ofEpochMilli(t).atZone(ZoneId.systemDefault()));
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SimpleDate) {
            SimpleDate other = (SimpleDate)obj;
            return this.year == other.year && this.month == other.month && this.day == other.day;
        }
        if (obj instanceof CharSequence) {
            return this.toString().equals(obj.toString());
        }
        return super.equals(obj);
    }

    @Override
    public int compareTo(Object other) {
        SimpleDate otherDate;
        if (other instanceof SimpleDate) {
            return this.compareTo((SimpleDate)other);
        }
        if (other instanceof CharSequence && (otherDate = SimpleDate.parse(other.toString())) != null) {
            return this.compareTo(otherDate);
        }
        throw new IllegalArgumentException(String.valueOf(other));
    }

    @Override
    public int compareTo(SimpleDate other) {
        return Long.compare(this.getTimeStamp(), other.getTimeStamp());
    }

    public int hashCode() {
        return Objects.hash(this.year, this.month, this.day);
    }

    public SimpleDate clone() {
        return new SimpleDate(this.year, this.month, this.day);
    }

    public String format(String pattern) {
        return DateTimeFormatter.ofPattern(pattern, Locale.ENGLISH).format(this.toLocalDate());
    }

    public LocalDate toLocalDate() {
        return LocalDate.of(this.year, this.month, this.day);
    }

    public Instant toInstant() {
        return this.toLocalDate().atStartOfDay(ZoneId.systemDefault()).toInstant();
    }

    public long getTimeStamp() {
        return this.toInstant().toEpochMilli();
    }

    public String toString() {
        return String.format("%04d-%02d-%02d", this.year, this.month, this.day);
    }

    public static SimpleDate parse(String date) {
        Matcher m;
        if (date != null && date.length() > 0 && (m = DATE_FORMAT.matcher(date)).matches()) {
            return new SimpleDate(Integer.parseInt(m.group(1)), Integer.parseInt(m.group(2)), Integer.parseInt(m.group(3)));
        }
        return null;
    }
}

