/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.web;

import java.io.FileNotFoundException;
import java.net.URI;
import java.net.URL;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Icon;
import net.filebot.Cache;
import net.filebot.CacheType;
import net.filebot.CachedResource;
import net.filebot.Logging;
import net.filebot.ResourceManager;
import net.filebot.similarity.Normalization;
import net.filebot.util.JsonUtilities;
import net.filebot.util.StringUtilities;
import net.filebot.web.Artwork;
import net.filebot.web.ArtworkProvider;
import net.filebot.web.FloodLimit;
import net.filebot.web.Movie;
import net.filebot.web.MovieIdentificationService;
import net.filebot.web.MovieInfo;
import net.filebot.web.Person;
import net.filebot.web.SimpleDate;
import net.filebot.web.Trailer;
import net.filebot.web.WebRequest;

public class TMDbClient
implements MovieIdentificationService,
ArtworkProvider {
    private static final FloodLimit REQUEST_LIMIT = new FloodLimit(35, 10L, TimeUnit.SECONDS);
    private final String host = "api.themoviedb.org";
    private final String version = "3";
    private String apikey;
    private boolean adult;

    public TMDbClient(String apikey, boolean adult) {
        this.apikey = apikey;
        this.adult = adult;
    }

    @Override
    public String getIdentifier() {
        return "TheMovieDB";
    }

    @Override
    public Icon getIcon() {
        return ResourceManager.getIcon("search.themoviedb");
    }

    protected Matcher getNameYearMatcher(String query) {
        return Pattern.compile("(.+)\\b[(]?((?:19|20)\\d{2})[)]?$").matcher(query.trim());
    }

    @Override
    public List<Movie> searchMovie(String query, Locale locale) throws Exception {
        Matcher nameYear = this.getNameYearMatcher(query);
        if (nameYear.matches()) {
            return this.searchMovie(nameYear.group(1).trim(), Integer.parseInt(nameYear.group(2)), locale, false);
        }
        return this.searchMovie(query.trim(), -1, locale, false);
    }

    public List<Movie> searchMovie(String movieName, int movieYear, Locale locale, boolean extendedInfo) throws Exception {
        if (movieName.length() < 3 && (movieName.length() < 1 || movieYear <= 0)) {
            return Collections.emptyList();
        }
        LinkedHashMap<String, Object> query = new LinkedHashMap<String, Object>(2);
        query.put("query", movieName);
        if (movieYear > 0) {
            query.put("year", movieYear);
        }
        if (this.adult) {
            query.put("include_adult", this.adult);
        }
        Object response = this.request("search/movie", query, locale);
        return JsonUtilities.streamJsonObjects(response, "results").map(it -> {
            int id = -1;
            int year = -1;
            try {
                id = JsonUtilities.getDecimal(it, "id").intValue();
                year = StringUtilities.matchInteger(JsonUtilities.getString(it, "release_date"));
            }
            catch (Exception e) {
                Logging.debug.fine(Logging.format("Missing data: release_date => %s", it));
                return null;
            }
            String title = JsonUtilities.getString(it, "title");
            String originalTitle = JsonUtilities.getString(it, "original_title");
            if (title == null) {
                title = originalTitle;
            }
            String[] alternativeTitles = this.getAlternativeTitles("movie/" + id, "titles", title, originalTitle, extendedInfo);
            return new Movie(title, alternativeTitles, year, -1, id, locale);
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    protected String[] getAlternativeTitles(String path, String key, String title, String originalTitle, boolean extendedInfo) {
        LinkedHashSet<String> alternativeTitles = new LinkedHashSet<String>();
        if (originalTitle != null) {
            alternativeTitles.add(originalTitle);
        }
        if (extendedInfo) {
            try {
                Object response = this.request(path + "/alternative_titles", Collections.emptyMap(), Locale.ENGLISH);
                JsonUtilities.streamJsonObjects(response, key).map(n -> JsonUtilities.getString(n, "title")).filter(Objects::nonNull).filter(n -> n.length() >= 2).forEach(alternativeTitles::add);
            }
            catch (Exception e) {
                Logging.debug.warning(Logging.format("Failed to fetch alternative titles for %s => %s", path, e));
            }
        }
        alternativeTitles.remove(title);
        return alternativeTitles.toArray(new String[0]);
    }

    public URI getMoviePageLink(int tmdbid) {
        return URI.create("https://www.themoviedb.org/movie/" + tmdbid);
    }

    @Override
    public Movie getMovieDescriptor(Movie id, Locale locale) throws Exception {
        MovieInfo info;
        if ((id.getTmdbId() > 0 || id.getImdbId() > 0) && (info = this.getMovieInfo(id, locale, false)) != null) {
            String[] stringArray;
            String name = info.getName();
            if (info.getOriginalName() == null || info.getOriginalName().isEmpty() || info.getOriginalName().equals(name)) {
                stringArray = new String[]{};
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = info.getOriginalName();
            }
            String[] aliasNames = stringArray;
            int year = info.getReleased() != null ? info.getReleased().getYear() : id.getYear();
            int tmdbid = info.getId();
            int imdbid = info.getImdbId() != null ? info.getImdbId() : 0;
            return new Movie(name, aliasNames, year, imdbid, tmdbid, locale);
        }
        return null;
    }

    public MovieInfo getMovieInfo(Movie movie, Locale locale, boolean extendedInfo) throws Exception {
        try {
            if (movie.getTmdbId() > 0) {
                return this.getMovieInfo(String.valueOf(movie.getTmdbId()), locale, extendedInfo);
            }
            if (movie.getImdbId() > 0) {
                return this.getMovieInfo(String.format("tt%07d", movie.getImdbId()), locale, extendedInfo);
            }
        }
        catch (FileNotFoundException | NullPointerException e) {
            Logging.debug.log(Level.WARNING, String.format("Movie data not found: %s [%d / %d]", movie, movie.getTmdbId(), movie.getImdbId()));
        }
        return null;
    }

    public MovieInfo getMovieInfo(String id, Locale locale, boolean extendedInfo) throws Exception {
        Object response = this.request("movie/" + id, extendedInfo ? Collections.singletonMap("append_to_response", "alternative_titles,releases,casts,trailers") : Collections.emptyMap(), locale);
        EnumMap<MovieInfo.Property, String> fields = JsonUtilities.getEnumMap(response, MovieInfo.Property.class);
        try {
            fields.computeIfPresent(MovieInfo.Property.poster_path, (k, v) -> extendedInfo ? this.resolveImage((String)v).toString() : null);
        }
        catch (Exception e) {
            Logging.debug.warning(Logging.format("Bad data: poster_path => %s", response));
        }
        try {
            Map<?, ?> collection = JsonUtilities.getMap(response, "belongs_to_collection");
            fields.put(MovieInfo.Property.collection, JsonUtilities.getString(collection, "name"));
        }
        catch (Exception e) {
            Logging.debug.warning(Logging.format("Bad data: belongs_to_collection => %s", response));
        }
        ArrayList<String> genres = new ArrayList<String>();
        try {
            JsonUtilities.streamJsonObjects(response, "genres").map(it -> JsonUtilities.getString(it, "name")).filter(Objects::nonNull).forEach(genres::add);
        }
        catch (Exception e) {
            Logging.debug.warning(Logging.format("Bad data: genres => %s", response));
        }
        ArrayList<String> spokenLanguages = new ArrayList<String>();
        try {
            JsonUtilities.streamJsonObjects(response, "spoken_languages").map(it -> JsonUtilities.getString(it, "iso_639_1")).filter(Objects::nonNull).forEach(spokenLanguages::add);
        }
        catch (Exception e) {
            Logging.debug.warning(Logging.format("Bad data: spoken_languages => %s", response));
        }
        ArrayList<String> productionCountries = new ArrayList<String>();
        try {
            JsonUtilities.streamJsonObjects(response, "production_countries").map(it -> JsonUtilities.getString(it, "iso_3166_1")).filter(Objects::nonNull).forEach(productionCountries::add);
        }
        catch (Exception e) {
            Logging.debug.warning(Logging.format("Bad data: production_countries => %s", response));
        }
        ArrayList<String> productionCompanies = new ArrayList<String>();
        try {
            JsonUtilities.streamJsonObjects(response, "production_companies").map(it -> JsonUtilities.getString(it, "name")).filter(Objects::nonNull).forEach(productionCompanies::add);
        }
        catch (Exception e) {
            Logging.debug.warning(Logging.format("Bad data: production_companies => %s", response));
        }
        ArrayList<String> alternativeTitles = new ArrayList<String>();
        try {
            JsonUtilities.streamJsonObjects(JsonUtilities.getMap(response, "alternative_titles"), "titles").map(it -> JsonUtilities.getString(it, "title")).filter(Objects::nonNull).forEach(alternativeTitles::add);
        }
        catch (Exception e) {
            Logging.debug.warning(Logging.format("Bad data: alternative_titles => %s", response));
        }
        LinkedHashMap<String, String> certifications = new LinkedHashMap<String, String>();
        try {
            String countryCode = locale.getCountry().isEmpty() ? "US" : locale.getCountry();
            JsonUtilities.streamJsonObjects(JsonUtilities.getMap(response, "releases"), "countries").forEach(it -> {
                String certificationCountry = JsonUtilities.getString(it, "iso_3166_1");
                String certification = JsonUtilities.getString(it, "certification");
                if (certification != null && certificationCountry != null) {
                    if (countryCode.equals(certificationCountry)) {
                        fields.put(MovieInfo.Property.certification, certification);
                    }
                    certifications.put(certificationCountry, certification);
                }
            });
        }
        catch (Exception e) {
            Logging.debug.warning(Logging.format("Bad data: certification => %s", response));
        }
        ArrayList<Person> cast = new ArrayList<Person>();
        try {
            Function<String, String> normalize = s -> Normalization.replaceSpace(s, " ").trim();
            Stream.of("cast", "crew").flatMap(section -> JsonUtilities.streamJsonObjects(JsonUtilities.getMap(response, "casts"), section)).map(it -> {
                String name = (String)JsonUtilities.getStringValue(it, "name", normalize);
                String character = (String)JsonUtilities.getStringValue(it, "character", normalize);
                String job = (String)JsonUtilities.getStringValue(it, "job", normalize);
                String department = (String)JsonUtilities.getStringValue(it, "department", normalize);
                Integer order = JsonUtilities.getInteger(it, "order");
                URL image = JsonUtilities.getStringValue(it, "profile_path", this::resolveImage);
                return new Person(name, character, job, department, order, image);
            }).sorted(Person.CREDIT_ORDER).forEach(cast::add);
        }
        catch (Exception e) {
            Logging.debug.warning(Logging.format("Bad data: casts => %s", response));
        }
        ArrayList<Trailer> trailers = new ArrayList<Trailer>();
        try {
            Stream.of("quicktime", "youtube").forEach(section -> JsonUtilities.streamJsonObjects(JsonUtilities.getMap(response, "trailers"), section).map(it -> {
                LinkedHashMap<String, String> sources = new LinkedHashMap<String, String>();
                Stream.concat(Stream.of(it), JsonUtilities.streamJsonObjects(it, "sources")).forEach(source -> {
                    String size = JsonUtilities.getString(source, "size");
                    if (size != null) {
                        sources.put(size, JsonUtilities.getString(source, "source"));
                    }
                });
                return new Trailer((String)section, JsonUtilities.getString(it, "name"), (Map<String, String>)sources);
            }).forEach(trailers::add));
        }
        catch (Exception e) {
            Logging.debug.warning(Logging.format("Bad data: trailers => %s", response));
        }
        return new MovieInfo(fields, alternativeTitles, genres, certifications, spokenLanguages, productionCountries, productionCompanies, cast, trailers);
    }

    @Override
    public List<Artwork> getArtwork(int id, String category, Locale locale) throws Exception {
        Object images = this.request("movie/" + id + "/images", Collections.emptyMap(), Locale.ROOT);
        return JsonUtilities.streamJsonObjects(images, category).map(it -> {
            URL image = JsonUtilities.getStringValue(it, "file_path", this::resolveImage);
            String width = JsonUtilities.getString(it, "width");
            String height = JsonUtilities.getString(it, "height");
            Locale language = JsonUtilities.getStringValue(it, "iso_639_1", Locale::new);
            return new Artwork(Stream.of(category, String.join((CharSequence)"x", width, height)), image, language, null);
        }).sorted(Artwork.RATING_ORDER).collect(Collectors.toList());
    }

    protected Object getConfiguration() throws Exception {
        return this.request("configuration", Collections.emptyMap(), Locale.ROOT);
    }

    protected URL resolveImage(String path) {
        if (path == null || path.isEmpty()) {
            return null;
        }
        try {
            String mirror = (String)Cache.getCache(this.getName(), CacheType.Monthly).computeIfAbsent("configuration.base_url", it -> JsonUtilities.getString(JsonUtilities.getMap(this.getConfiguration(), "images"), "base_url"));
            return new URL(mirror + "original" + path);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(path, e);
        }
    }

    public Map<String, List<String>> getAlternativeTitles(int id) throws Exception {
        Object titles = this.request("movie/" + id + "/alternative_titles", Collections.emptyMap(), Locale.ROOT);
        return JsonUtilities.streamJsonObjects(titles, "titles").collect(Collectors.groupingBy(it -> JsonUtilities.getString(it, "iso_3166_1"), LinkedHashMap::new, Collectors.mapping(it -> JsonUtilities.getString(it, "title"), Collectors.toList())));
    }

    public List<Movie> discover(LocalDate startDate, LocalDate endDate, Locale locale) throws Exception {
        LinkedHashMap<String, Object> parameters = new LinkedHashMap<String, Object>(3);
        parameters.put("primary_release_date.gte", startDate);
        parameters.put("primary_release_date.lte", endDate);
        parameters.put("sort_by", "popularity.desc");
        return this.discover(parameters, locale);
    }

    public List<Movie> discover(int year, Locale locale) throws Exception {
        LinkedHashMap<String, Object> parameters = new LinkedHashMap<String, Object>(2);
        parameters.put("primary_release_year", year);
        parameters.put("sort_by", "vote_count.desc");
        return this.discover(parameters, locale);
    }

    public List<Movie> discover(Map<String, Object> parameters, Locale locale) throws Exception {
        Object json = this.request("discover/movie", parameters, locale);
        return JsonUtilities.streamJsonObjects(json, "results").map(it -> {
            String title = JsonUtilities.getString(it, "title");
            int year = JsonUtilities.getStringValue(it, "release_date", SimpleDate::parse).getYear();
            int id = JsonUtilities.getInteger(it, "id");
            return new Movie(title, null, year, 0, id, locale);
        }).collect(Collectors.toList());
    }

    protected Object request(String resource, Map<String, Object> parameters, Locale locale) throws Exception {
        String key = parameters.isEmpty() ? resource : resource + '?' + WebRequest.encodeParameters(parameters, true);
        String language = this.getLanguageCode(locale);
        String cacheName = language == null ? this.getName() : this.getName() + "_" + language;
        Cache cache = Cache.getCache(cacheName, CacheType.Monthly);
        Object json = cache.json(key, k -> this.getResource((String)k, language)).fetch(CachedResource.withPermit(CachedResource.fetchIfNoneMatch(url -> key, cache), r -> REQUEST_LIMIT.acquirePermit())).expire(Cache.ONE_WEEK).get();
        if (JsonUtilities.asMap(json).isEmpty()) {
            throw new FileNotFoundException(String.format("Resource is empty: %s => %s", json, this.getResource(key, language)));
        }
        return json;
    }

    protected URL getResource(String path, String language) throws Exception {
        StringBuilder file = new StringBuilder();
        file.append('/').append("3");
        file.append('/').append(path);
        file.append(path.lastIndexOf(63) < 0 ? (char)'?' : '&');
        if (language != null) {
            file.append("language=").append(language).append('&');
        }
        file.append("api_key=").append(this.apikey);
        return new URL("https", "api.themoviedb.org", file.toString());
    }

    protected String getLanguageCode(Locale locale) {
        String language = locale.getLanguage();
        if (language.length() == 2) {
            if (locale.getCountry().length() == 2) {
                return locale.getLanguage() + '-' + locale.getCountry();
            }
            return locale.getLanguage();
        }
        return null;
    }
}

