/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.ssh;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.tools.ant.taskdefs.optional.ssh.AbstractSshMessage;
import org.apache.tools.ant.util.FileUtils;

public class ScpFromMessage
extends AbstractSshMessage {
    private static final int HUNDRED_KILOBYTES = 102400;
    private static final byte LINE_FEED = 10;
    private static final int BUFFER_SIZE = 102400;
    private String remoteFile;
    private File localFile;
    private boolean isRecursive = false;
    private boolean preserveLastModified = false;

    public ScpFromMessage(Session session) {
        super(session);
    }

    public ScpFromMessage(boolean verbose, Session session) {
        super(verbose, session);
    }

    public ScpFromMessage(boolean verbose, Session session, String aRemoteFile, File aLocalFile, boolean recursive) {
        this(false, session, aRemoteFile, aLocalFile, recursive, false);
    }

    public ScpFromMessage(Session session, String aRemoteFile, File aLocalFile, boolean recursive) {
        this(false, session, aRemoteFile, aLocalFile, recursive);
    }

    public ScpFromMessage(boolean verbose, Session session, String aRemoteFile, File aLocalFile, boolean recursive, boolean preserveLastModified) {
        this(verbose, session, aRemoteFile, aLocalFile, recursive, preserveLastModified, false);
    }

    public ScpFromMessage(boolean verbose, Session session, String aRemoteFile, File aLocalFile, boolean recursive, boolean preserveLastModified, boolean compressed) {
        super(verbose, compressed, session);
        this.remoteFile = aRemoteFile;
        this.localFile = aLocalFile;
        this.isRecursive = recursive;
        this.preserveLastModified = preserveLastModified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws IOException, JSchException {
        String command = "scp -f ";
        if (this.isRecursive) {
            command = command + "-r ";
        }
        if (this.getCompressed()) {
            command = command + "-C ";
        }
        command = command + this.remoteFile;
        Channel channel = this.openExecChannel(command);
        try {
            OutputStream out = channel.getOutputStream();
            InputStream in = channel.getInputStream();
            channel.connect();
            this.sendAck(out);
            this.startRemoteCpProtocol(in, out, this.localFile);
        }
        finally {
            if (channel != null) {
                channel.disconnect();
            }
        }
        this.log("done\n");
    }

    protected boolean getPreserveLastModified() {
        return this.preserveLastModified;
    }

    private void startRemoteCpProtocol(InputStream in, OutputStream out, File localFile) throws IOException, JSchException {
        String serverResponse;
        File startFile = localFile;
        while (true) {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            while (true) {
                int read;
                if ((read = in.read()) < 0) {
                    return;
                }
                if ((byte)read == 10) break;
                stream.write(read);
            }
            serverResponse = stream.toString("UTF-8");
            if (serverResponse.charAt(0) == 'C') {
                this.parseAndFetchFile(serverResponse, startFile, out, in);
                continue;
            }
            if (serverResponse.charAt(0) == 'D') {
                startFile = this.parseAndCreateDirectory(serverResponse, startFile);
                this.sendAck(out);
                continue;
            }
            if (serverResponse.charAt(0) == 'E') {
                startFile = startFile.getParentFile();
                this.sendAck(out);
                continue;
            }
            if (serverResponse.charAt(0) == '\u0001' || serverResponse.charAt(0) == '\u0002') break;
        }
        throw new IOException(serverResponse.substring(1));
    }

    private File parseAndCreateDirectory(String serverResponse, File localFile) {
        int start = serverResponse.indexOf(" ");
        start = serverResponse.indexOf(" ", start + 1);
        String directoryName = serverResponse.substring(start + 1);
        if (localFile.isDirectory()) {
            File dir = new File(localFile, directoryName);
            dir.mkdir();
            this.log("Creating: " + dir);
            return dir;
        }
        return null;
    }

    private void parseAndFetchFile(String serverResponse, File localFile, OutputStream out, InputStream in) throws IOException, JSchException {
        int start = 0;
        int end = serverResponse.indexOf(" ", start + 1);
        start = end + 1;
        end = serverResponse.indexOf(" ", start + 1);
        long filesize = Long.parseLong(serverResponse.substring(start, end));
        String filename = serverResponse.substring(end + 1);
        this.log("Receiving: " + filename + " : " + filesize);
        File transferFile = localFile.isDirectory() ? new File(localFile, filename) : localFile;
        this.fetchFile(transferFile, filesize, out, in);
        this.waitForAck(in);
        this.sendAck(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchFile(File localFile, long filesize, OutputStream out, InputStream in) throws IOException, JSchException {
        byte[] buf = new byte[102400];
        this.sendAck(out);
        FileOutputStream fos = new FileOutputStream(localFile);
        long totalLength = 0L;
        long startTime = System.currentTimeMillis();
        boolean trackProgress = this.getVerbose() && filesize > 102400L;
        long initFilesize = filesize;
        int percentTransmitted = 0;
        try {
            while (true) {
                int length;
                if ((length = in.read(buf, 0, 102400L < filesize ? 102400 : (int)filesize)) < 0) {
                    throw new EOFException("Unexpected end of stream.");
                }
                fos.write(buf, 0, length);
                totalLength += (long)length;
                if ((filesize -= (long)length) == 0L) {
                    break;
                }
                if (!trackProgress) continue;
                percentTransmitted = this.trackProgress(initFilesize, totalLength, percentTransmitted);
            }
        }
        finally {
            long endTime = System.currentTimeMillis();
            this.logStats(startTime, endTime, totalLength);
            fos.flush();
            fos.close();
        }
        if (this.getPreserveLastModified()) {
            this.setLastModified(localFile);
        }
    }

    private void setLastModified(File localFile) throws JSchException {
        SftpATTRS fileAttributes = null;
        ChannelSftp channel = this.openSftpChannel();
        channel.connect();
        try {
            fileAttributes = channel.lstat(ScpFromMessage.remoteDir(this.remoteFile) + localFile.getName());
        }
        catch (SftpException e) {
            throw new JSchException("failed to stat remote file", e);
        }
        FileUtils.getFileUtils().setFileLastModified(localFile, (long)fileAttributes.getMTime() * 1000L);
    }

    private static String remoteDir(String remoteFile) {
        int index = remoteFile.lastIndexOf("/");
        if (index < 0) {
            index = remoteFile.lastIndexOf("\\");
        }
        return index > -1 ? remoteFile.substring(0, index + 1) : "";
    }
}

