/*
 * Decompiled with CFR 0.152.
 */
package redstone.xmlrpc.interceptors;

import javax.servlet.ServletContext;
import redstone.xmlrpc.XmlRpcInvocation;
import redstone.xmlrpc.XmlRpcInvocationInterceptor;

public class DebugInvocationInterceptor
implements XmlRpcInvocationInterceptor {
    private ServletContext servletContext;

    public DebugInvocationInterceptor() {
    }

    public DebugInvocationInterceptor(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public boolean before(XmlRpcInvocation xmlRpcInvocation) {
        StringBuffer stringBuffer = new StringBuffer(192);
        stringBuffer.append(xmlRpcInvocation.getInvocationId()).append(": ").append(xmlRpcInvocation.getHandlerName()).append('.').append(xmlRpcInvocation.getMethodName()).append(xmlRpcInvocation.getArguments().toString());
        if (this.servletContext != null) {
            this.servletContext.log(stringBuffer.toString());
        } else {
            System.out.println(stringBuffer.toString());
        }
        return true;
    }

    public Object after(XmlRpcInvocation xmlRpcInvocation, Object object) {
        StringBuffer stringBuffer = new StringBuffer(192);
        stringBuffer.append(xmlRpcInvocation.getInvocationId()).append(": ").append(object);
        if (this.servletContext != null) {
            this.servletContext.log(stringBuffer.toString());
        } else {
            System.out.println(stringBuffer.toString());
        }
        return object;
    }

    public void onException(XmlRpcInvocation xmlRpcInvocation, Throwable throwable) {
        StringBuffer stringBuffer = new StringBuffer(192);
        stringBuffer.append(xmlRpcInvocation.getInvocationId()).append(": ").append(throwable.getMessage());
        if (this.servletContext != null) {
            this.servletContext.log(stringBuffer.toString(), throwable);
        } else {
            if (throwable.getCause() != null) {
                stringBuffer.append(throwable.getCause().getMessage());
            }
            System.out.println(stringBuffer.toString());
        }
    }
}

