/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.shef.wit.simmetrics.similaritymetrics;

import java.io.Serializable;
import java.util.ArrayList;
import uk.ac.shef.wit.simmetrics.similaritymetrics.AbstractStringMetric;
import uk.ac.shef.wit.simmetrics.similaritymetrics.SmithWatermanGotoh;
import uk.ac.shef.wit.simmetrics.tokenisers.InterfaceTokeniser;
import uk.ac.shef.wit.simmetrics.tokenisers.TokeniserWhitespace;

public class MongeElkan
extends AbstractStringMetric
implements Serializable {
    private final float ESTIMATEDTIMINGCONST = 0.0344f;
    final InterfaceTokeniser tokeniser;
    private final AbstractStringMetric internalStringMetric;

    public String getSimilarityExplained(String string1, String string2) {
        return null;
    }

    public MongeElkan() {
        this.tokeniser = new TokeniserWhitespace();
        this.internalStringMetric = new SmithWatermanGotoh();
    }

    public MongeElkan(InterfaceTokeniser tokeniserToUse) {
        this.tokeniser = tokeniserToUse;
        this.internalStringMetric = new SmithWatermanGotoh();
    }

    public MongeElkan(InterfaceTokeniser tokeniserToUse, AbstractStringMetric metricToUse) {
        this.tokeniser = tokeniserToUse;
        this.internalStringMetric = metricToUse;
    }

    public MongeElkan(AbstractStringMetric metricToUse) {
        this.tokeniser = new TokeniserWhitespace();
        this.internalStringMetric = metricToUse;
    }

    public String getShortDescriptionString() {
        return "MongeElkan";
    }

    public String getLongDescriptionString() {
        return "Implements the Monge Elkan algorithm providing an matching style similarity measure between two strings";
    }

    public float getSimilarityTimingEstimated(String string1, String string2) {
        float str1Tokens = this.tokeniser.tokenizeToArrayList(string1).size();
        float str2Tokens = this.tokeniser.tokenizeToArrayList(string2).size();
        return ((str1Tokens + str2Tokens) * str1Tokens + (str1Tokens + str2Tokens) * str2Tokens) * 0.0344f;
    }

    public final float getSimilarity(String string1, String string2) {
        ArrayList<String> str1Tokens = this.tokeniser.tokenizeToArrayList(string1);
        ArrayList<String> str2Tokens = this.tokeniser.tokenizeToArrayList(string2);
        float sumMatches = 0.0f;
        for (String str1Token : str1Tokens) {
            float maxFound = 0.0f;
            for (String str2Token : str2Tokens) {
                float found = this.internalStringMetric.getSimilarity(str1Token, str2Token);
                if (!(found > maxFound)) continue;
                maxFound = found;
            }
            sumMatches += maxFound;
        }
        return sumMatches / (float)str1Tokens.size();
    }

    public float getUnNormalisedSimilarity(String string1, String string2) {
        return this.getSimilarity(string1, string2);
    }
}

