/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.graphics;

import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.TextCharacter;
import com.googlecode.lanterna.graphics.AbstractTextGraphics;
import com.googlecode.lanterna.graphics.TextGraphics;

public class DoublePrintingTextGraphics
extends AbstractTextGraphics {
    private final TextGraphics underlyingTextGraphics;

    public DoublePrintingTextGraphics(TextGraphics underlyingTextGraphics) {
        this.underlyingTextGraphics = underlyingTextGraphics;
    }

    @Override
    public TextGraphics setCharacter(int columnIndex, int rowIndex, TextCharacter textCharacter) {
        this.underlyingTextGraphics.setCharacter(columnIndex *= 2, rowIndex, textCharacter);
        this.underlyingTextGraphics.setCharacter(columnIndex + 1, rowIndex, textCharacter);
        return this;
    }

    @Override
    public TextCharacter getCharacter(int columnIndex, int rowIndex) {
        return this.underlyingTextGraphics.getCharacter(columnIndex *= 2, rowIndex);
    }

    @Override
    public TerminalSize getSize() {
        TerminalSize size = this.underlyingTextGraphics.getSize();
        return size.withColumns(size.getColumns() / 2);
    }
}

