/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.graphics;

import com.googlecode.lanterna.SGR;
import com.googlecode.lanterna.TextColor;
import com.googlecode.lanterna.graphics.Theme;
import com.googlecode.lanterna.graphics.ThemeDefinition;
import com.googlecode.lanterna.graphics.ThemeStyle;
import com.googlecode.lanterna.gui2.Component;
import com.googlecode.lanterna.gui2.ComponentRenderer;
import com.googlecode.lanterna.gui2.WindowDecorationRenderer;
import com.googlecode.lanterna.gui2.WindowPostRenderer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Deprecated
public final class PropertiesTheme
implements Theme {
    private static final String STYLE_NORMAL = "";
    private static final String STYLE_PRELIGHT = "PRELIGHT";
    private static final String STYLE_SELECTED = "SELECTED";
    private static final String STYLE_ACTIVE = "ACTIVE";
    private static final String STYLE_INSENSITIVE = "INSENSITIVE";
    private static final Pattern STYLE_FORMAT = Pattern.compile("([a-zA-Z]+)(\\[([a-zA-Z0-9-_]+)])?");
    private final ThemeTreeNode rootNode = new ThemeTreeNode(null);
    private final WindowPostRenderer windowPostRenderer;
    private final WindowDecorationRenderer windowDecorationRenderer;

    public PropertiesTheme(Properties properties) {
        this.rootNode.foregroundMap.put(STYLE_NORMAL, TextColor.ANSI.WHITE);
        this.rootNode.backgroundMap.put(STYLE_NORMAL, TextColor.ANSI.BLACK);
        this.windowPostRenderer = (WindowPostRenderer)PropertiesTheme.instanceByClassName(properties.getProperty("postrenderer", STYLE_NORMAL));
        this.windowDecorationRenderer = (WindowDecorationRenderer)PropertiesTheme.instanceByClassName(properties.getProperty("windowdecoration", STYLE_NORMAL));
        for (String key : properties.stringPropertyNames()) {
            String definition = this.getDefinition(key);
            ThemeTreeNode node = this.getNode(definition);
            node.apply(this.getStyle(key), properties.getProperty(key));
        }
    }

    private ThemeTreeNode getNode(String definition) {
        ThemeTreeNode parentNode;
        if (definition.equals(STYLE_NORMAL)) {
            return this.rootNode;
        }
        if (definition.contains(".")) {
            String parent = definition.substring(0, definition.lastIndexOf("."));
            parentNode = this.getNode(parent);
            definition = definition.substring(definition.lastIndexOf(".") + 1);
        } else {
            parentNode = this.rootNode;
        }
        if (!parentNode.childMap.containsKey(definition)) {
            parentNode.childMap.put(definition, new ThemeTreeNode(parentNode));
        }
        return (ThemeTreeNode)parentNode.childMap.get(definition);
    }

    private String getDefinition(String propertyName) {
        if (!propertyName.contains(".")) {
            return STYLE_NORMAL;
        }
        return propertyName.substring(0, propertyName.lastIndexOf("."));
    }

    private String getStyle(String propertyName) {
        if (!propertyName.contains(".")) {
            return propertyName;
        }
        return propertyName.substring(propertyName.lastIndexOf(".") + 1);
    }

    @Override
    public ThemeDefinition getDefaultDefinition() {
        return new DefinitionImpl(Collections.singletonList(this.rootNode));
    }

    @Override
    public ThemeDefinition getDefinition(Class<?> clazz) {
        String name = clazz.getName();
        ArrayList<ThemeTreeNode> path = new ArrayList<ThemeTreeNode>();
        ThemeTreeNode currentNode = this.rootNode;
        while (!name.equals(STYLE_NORMAL)) {
            path.add(currentNode);
            String nextNodeName = name;
            if (nextNodeName.contains(".")) {
                nextNodeName = nextNodeName.substring(0, name.indexOf("."));
                name = name.substring(name.indexOf(".") + 1);
            }
            if (!currentNode.childMap.containsKey(nextNodeName)) break;
            currentNode = (ThemeTreeNode)currentNode.childMap.get(nextNodeName);
        }
        return new DefinitionImpl(path);
    }

    @Override
    public WindowPostRenderer getWindowPostRenderer() {
        return this.windowPostRenderer;
    }

    @Override
    public WindowDecorationRenderer getWindowDecorationRenderer() {
        return this.windowDecorationRenderer;
    }

    private static Object instanceByClassName(String className) {
        if (className == null || className.trim().isEmpty()) {
            return null;
        }
        try {
            return Class.forName(className).newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static class ThemeTreeNode {
        private final Map<String, ThemeTreeNode> childMap = new HashMap<String, ThemeTreeNode>();
        private final Map<String, TextColor> foregroundMap = new HashMap<String, TextColor>();
        private final Map<String, TextColor> backgroundMap = new HashMap<String, TextColor>();
        private final Map<String, EnumSet<SGR>> sgrMap = new HashMap<String, EnumSet<SGR>>();
        private final Map<String, Character> characterMap = new HashMap<String, Character>();
        private final Map<String, String> propertyMap = new HashMap<String, String>();
        private boolean cursorVisible = true;
        private String renderer = null;

        private ThemeTreeNode(ThemeTreeNode parent) {
        }

        public void apply(String style, String value) {
            String group;
            value = value.trim();
            Matcher matcher = STYLE_FORMAT.matcher(style);
            if (!matcher.matches()) {
                throw new IllegalArgumentException("Unknown style declaration: " + style);
            }
            String styleComponent = matcher.group(1);
            String string = group = matcher.groupCount() > 2 ? matcher.group(3) : null;
            if (styleComponent.toLowerCase().trim().equals("foreground")) {
                this.foregroundMap.put(this.getCategory(group), this.parseValue(value));
            } else if (styleComponent.toLowerCase().trim().equals("background")) {
                this.backgroundMap.put(this.getCategory(group), this.parseValue(value));
            } else if (styleComponent.toLowerCase().trim().equals("sgr")) {
                this.sgrMap.put(this.getCategory(group), this.parseSGR(value));
            } else if (styleComponent.toLowerCase().trim().equals("char")) {
                this.characterMap.put(this.getCategory(group), Character.valueOf(value.isEmpty() ? (char)' ' : value.charAt(0)));
            } else if (styleComponent.toLowerCase().trim().equals("cursor")) {
                this.cursorVisible = Boolean.parseBoolean(value);
            } else if (styleComponent.toLowerCase().trim().equals("property")) {
                this.propertyMap.put(this.getCategory(group), value.isEmpty() ? null : value.trim());
            } else if (styleComponent.toLowerCase().trim().equals("renderer")) {
                this.renderer = value.trim().isEmpty() ? null : value.trim();
            } else if (!styleComponent.toLowerCase().trim().equals("postrenderer") && !styleComponent.toLowerCase().trim().equals("windowdecoration")) {
                throw new IllegalArgumentException("Unknown style component \"" + styleComponent + "\" in style \"" + style + "\"");
            }
        }

        private TextColor parseValue(String value) {
            return TextColor.Factory.fromString(value);
        }

        private EnumSet<SGR> parseSGR(String value) {
            value = value.trim();
            String[] sgrEntries = value.split(",");
            EnumSet<SGR> sgrSet = EnumSet.noneOf(SGR.class);
            for (String entry : sgrEntries) {
                if ((entry = entry.trim().toUpperCase()).isEmpty()) continue;
                try {
                    sgrSet.add(SGR.valueOf(entry));
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("Unknown SGR code \"" + entry + "\"", e);
                }
            }
            return sgrSet;
        }

        private String getCategory(String group) {
            if (group == null) {
                return PropertiesTheme.STYLE_NORMAL;
            }
            for (String style : Arrays.asList(PropertiesTheme.STYLE_ACTIVE, PropertiesTheme.STYLE_INSENSITIVE, PropertiesTheme.STYLE_PRELIGHT, PropertiesTheme.STYLE_NORMAL, PropertiesTheme.STYLE_SELECTED)) {
                if (!group.toUpperCase().equals(style)) continue;
                return style;
            }
            return group;
        }
    }

    private class StyleImpl
    implements ThemeStyle {
        private final List<ThemeTreeNode> path;
        private final String name;

        private StyleImpl(List<ThemeTreeNode> path, String name) {
            this.path = path;
            this.name = name;
        }

        @Override
        public TextColor getForeground() {
            ListIterator<ThemeTreeNode> iterator = this.path.listIterator(this.path.size());
            while (iterator.hasPrevious()) {
                ThemeTreeNode node = iterator.previous();
                if (!node.foregroundMap.containsKey(this.name)) continue;
                return (TextColor)node.foregroundMap.get(this.name);
            }
            if (!this.name.equals(PropertiesTheme.STYLE_NORMAL)) {
                return new StyleImpl(this.path, PropertiesTheme.STYLE_NORMAL).getForeground();
            }
            return TextColor.ANSI.WHITE;
        }

        @Override
        public TextColor getBackground() {
            ListIterator<ThemeTreeNode> iterator = this.path.listIterator(this.path.size());
            while (iterator.hasPrevious()) {
                ThemeTreeNode node = iterator.previous();
                if (!node.backgroundMap.containsKey(this.name)) continue;
                return (TextColor)node.backgroundMap.get(this.name);
            }
            if (!this.name.equals(PropertiesTheme.STYLE_NORMAL)) {
                return new StyleImpl(this.path, PropertiesTheme.STYLE_NORMAL).getBackground();
            }
            return TextColor.ANSI.BLACK;
        }

        @Override
        public EnumSet<SGR> getSGRs() {
            ListIterator<ThemeTreeNode> iterator = this.path.listIterator(this.path.size());
            while (iterator.hasPrevious()) {
                ThemeTreeNode node = iterator.previous();
                if (!node.sgrMap.containsKey(this.name)) continue;
                return EnumSet.copyOf((EnumSet)node.sgrMap.get(this.name));
            }
            if (!this.name.equals(PropertiesTheme.STYLE_NORMAL)) {
                return EnumSet.copyOf(new StyleImpl(this.path, PropertiesTheme.STYLE_NORMAL).getSGRs());
            }
            return EnumSet.noneOf(SGR.class);
        }
    }

    private class DefinitionImpl
    implements ThemeDefinition {
        final List<ThemeTreeNode> path;

        DefinitionImpl(List<ThemeTreeNode> path) {
            this.path = path;
        }

        @Override
        public ThemeStyle getNormal() {
            return new StyleImpl(this.path, PropertiesTheme.STYLE_NORMAL);
        }

        @Override
        public ThemeStyle getPreLight() {
            return new StyleImpl(this.path, PropertiesTheme.STYLE_PRELIGHT);
        }

        @Override
        public ThemeStyle getSelected() {
            return new StyleImpl(this.path, PropertiesTheme.STYLE_SELECTED);
        }

        @Override
        public ThemeStyle getActive() {
            return new StyleImpl(this.path, PropertiesTheme.STYLE_ACTIVE);
        }

        @Override
        public ThemeStyle getInsensitive() {
            return new StyleImpl(this.path, PropertiesTheme.STYLE_INSENSITIVE);
        }

        @Override
        public ThemeStyle getCustom(String name) {
            ThemeTreeNode lastElement = this.path.get(this.path.size() - 1);
            if (lastElement.sgrMap.containsKey(name) || lastElement.foregroundMap.containsKey(name) || lastElement.backgroundMap.containsKey(name)) {
                return new StyleImpl(this.path, name);
            }
            return null;
        }

        @Override
        public ThemeStyle getCustom(String name, ThemeStyle defaultValue) {
            ThemeStyle customStyle = this.getCustom(name);
            if (customStyle == null) {
                customStyle = defaultValue;
            }
            return customStyle;
        }

        @Override
        public char getCharacter(String name, char fallback) {
            Character character = (Character)this.path.get(this.path.size() - 1).characterMap.get(name);
            if (character == null) {
                return fallback;
            }
            return character.charValue();
        }

        @Override
        public boolean isCursorVisible() {
            return this.path.get(this.path.size() - 1).cursorVisible;
        }

        @Override
        public boolean getBooleanProperty(String name, boolean defaultValue) {
            String propertyValue = (String)this.path.get(this.path.size() - 1).propertyMap.get(name);
            if (propertyValue == null) {
                return defaultValue;
            }
            return Boolean.parseBoolean(propertyValue);
        }

        @Override
        public <T extends Component> ComponentRenderer<T> getRenderer(Class<T> type) {
            return (ComponentRenderer)PropertiesTheme.instanceByClassName(this.path.get(this.path.size() - 1).renderer);
        }
    }
}

