/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui2;

import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.TextColor;
import com.googlecode.lanterna.gui2.AbstractComponent;
import com.googlecode.lanterna.gui2.ComponentRenderer;
import com.googlecode.lanterna.gui2.TextGUIGraphics;

public class EmptySpace
extends AbstractComponent<EmptySpace> {
    private final TerminalSize size;
    private TextColor color;

    public EmptySpace() {
        this(null, TerminalSize.ONE);
    }

    public EmptySpace(TextColor color) {
        this(color, TerminalSize.ONE);
    }

    public EmptySpace(TerminalSize size) {
        this(null, size);
    }

    public EmptySpace(TextColor color, TerminalSize size) {
        this.color = color;
        this.size = size;
    }

    public void setColor(TextColor color) {
        this.color = color;
    }

    public TextColor getColor() {
        return this.color;
    }

    @Override
    protected ComponentRenderer<EmptySpace> createDefaultRenderer() {
        return new ComponentRenderer<EmptySpace>(){

            @Override
            public TerminalSize getPreferredSize(EmptySpace component) {
                return EmptySpace.this.size;
            }

            @Override
            public void drawComponent(TextGUIGraphics graphics, EmptySpace component) {
                graphics.applyThemeStyle(component.getThemeDefinition().getNormal());
                if (EmptySpace.this.color != null) {
                    graphics.setBackgroundColor(EmptySpace.this.color);
                }
                graphics.fill(' ');
            }
        };
    }
}

