/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui2;

import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.gui2.AbsoluteLayout;
import com.googlecode.lanterna.gui2.AbstractComponent;
import com.googlecode.lanterna.gui2.Component;
import com.googlecode.lanterna.gui2.ComponentRenderer;
import com.googlecode.lanterna.gui2.Container;
import com.googlecode.lanterna.gui2.Interactable;
import com.googlecode.lanterna.gui2.InteractableLookupMap;
import com.googlecode.lanterna.gui2.LayoutData;
import com.googlecode.lanterna.gui2.LayoutManager;
import com.googlecode.lanterna.gui2.LinearLayout;
import com.googlecode.lanterna.gui2.TextGUIGraphics;
import com.googlecode.lanterna.input.KeyStroke;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class Panel
extends AbstractComponent<Panel>
implements Container {
    private final List<Component> components;
    private LayoutManager layoutManager;
    private TerminalSize cachedPreferredSize;

    public Panel() {
        this(new LinearLayout());
    }

    public Panel(LayoutManager layoutManager) {
        if (layoutManager == null) {
            layoutManager = new AbsoluteLayout();
        }
        this.components = new ArrayList<Component>();
        this.layoutManager = layoutManager;
        this.cachedPreferredSize = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Panel addComponent(Component component) {
        if (component == null) {
            throw new IllegalArgumentException("Cannot add null component");
        }
        List<Component> list = this.components;
        synchronized (list) {
            if (this.components.contains(component)) {
                return this;
            }
            if (component.getParent() != null) {
                component.getParent().removeComponent(component);
            }
            this.components.add(component);
        }
        component.onAdded(this);
        this.invalidate();
        return this;
    }

    public Panel addComponent(Component component, LayoutData layoutData) {
        if (component != null) {
            component.setLayoutData(layoutData);
            this.addComponent(component);
        }
        return this;
    }

    @Override
    public boolean containsComponent(Component component) {
        return component != null && component.hasParent(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeComponent(Component component) {
        if (component == null) {
            throw new IllegalArgumentException("Cannot remove null component");
        }
        List<Component> list = this.components;
        synchronized (list) {
            int index = this.components.indexOf(component);
            if (index == -1) {
                return false;
            }
            if (this.getBasePane() != null && this.getBasePane().getFocusedInteractable() == component) {
                this.getBasePane().setFocusedInteractable(null);
            }
            this.components.remove(index);
        }
        component.onRemoved(this);
        this.invalidate();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Panel removeAllComponents() {
        List<Component> list = this.components;
        synchronized (list) {
            for (Component component : new ArrayList<Component>(this.components)) {
                this.removeComponent(component);
            }
        }
        return this;
    }

    public synchronized Panel setLayoutManager(LayoutManager layoutManager) {
        if (layoutManager == null) {
            layoutManager = new AbsoluteLayout();
        }
        this.layoutManager = layoutManager;
        this.invalidate();
        return this;
    }

    public LayoutManager getLayoutManager() {
        return this.layoutManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getChildCount() {
        List<Component> list = this.components;
        synchronized (list) {
            return this.components.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Component> getChildren() {
        List<Component> list = this.components;
        synchronized (list) {
            return new ArrayList<Component>(this.components);
        }
    }

    @Override
    protected ComponentRenderer<Panel> createDefaultRenderer() {
        return new ComponentRenderer<Panel>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public TerminalSize getPreferredSize(Panel component) {
                List list = Panel.this.components;
                synchronized (list) {
                    Panel.this.cachedPreferredSize = Panel.this.layoutManager.getPreferredSize(Panel.this.components);
                }
                return Panel.this.cachedPreferredSize;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void drawComponent(TextGUIGraphics graphics, Panel component) {
                if (Panel.this.isInvalid()) {
                    Panel.this.layout(graphics.getSize());
                }
                graphics.applyThemeStyle(Panel.this.getThemeDefinition().getNormal());
                graphics.fill(' ');
                List list = Panel.this.components;
                synchronized (list) {
                    for (Component child : Panel.this.components) {
                        TextGUIGraphics componentGraphics = graphics.newTextGraphics(child.getPosition(), child.getSize());
                        child.draw(componentGraphics);
                    }
                }
            }
        };
    }

    @Override
    public TerminalSize calculatePreferredSize() {
        if (this.cachedPreferredSize != null && !this.isInvalid()) {
            return this.cachedPreferredSize;
        }
        return super.calculatePreferredSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isInvalid() {
        List<Component> list = this.components;
        synchronized (list) {
            for (Component component : this.components) {
                if (!component.isInvalid()) continue;
                return true;
            }
        }
        return super.isInvalid() || this.layoutManager.hasChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Interactable nextFocus(Interactable fromThis) {
        boolean chooseNextAvailable = fromThis == null;
        List<Component> list = this.components;
        synchronized (list) {
            for (Component component : this.components) {
                Container container;
                if (chooseNextAvailable) {
                    Interactable firstInteractable;
                    if (component instanceof Interactable && ((Interactable)component).isEnabled() && ((Interactable)component).isFocusable()) {
                        return (Interactable)component;
                    }
                    if (!(component instanceof Container) || (firstInteractable = ((Container)component).nextFocus(null)) == null) continue;
                    return firstInteractable;
                }
                if (component == fromThis) {
                    chooseNextAvailable = true;
                    continue;
                }
                if (!(component instanceof Container) || !fromThis.isInside(container = (Container)component)) continue;
                Interactable next = container.nextFocus(fromThis);
                if (next == null) {
                    chooseNextAvailable = true;
                    continue;
                }
                return next;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Interactable previousFocus(Interactable fromThis) {
        boolean chooseNextAvailable = fromThis == null;
        ArrayList<Component> revComponents = new ArrayList<Component>();
        List<Component> list = this.components;
        synchronized (list) {
            revComponents.addAll(this.components);
        }
        Collections.reverse(revComponents);
        for (Component component : revComponents) {
            Container container;
            if (chooseNextAvailable) {
                Interactable lastInteractable;
                if (component instanceof Interactable && ((Interactable)component).isEnabled() && ((Interactable)component).isFocusable()) {
                    return (Interactable)component;
                }
                if (!(component instanceof Container) || (lastInteractable = ((Container)component).previousFocus(null)) == null) continue;
                return lastInteractable;
            }
            if (component == fromThis) {
                chooseNextAvailable = true;
                continue;
            }
            if (!(component instanceof Container) || !fromThis.isInside(container = (Container)component)) continue;
            Interactable next = container.previousFocus(fromThis);
            if (next == null) {
                chooseNextAvailable = true;
                continue;
            }
            return next;
        }
        return null;
    }

    @Override
    public boolean handleInput(KeyStroke key) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateLookupMap(InteractableLookupMap interactableLookupMap) {
        List<Component> list = this.components;
        synchronized (list) {
            for (Component component : this.components) {
                if (component instanceof Container) {
                    ((Container)component).updateLookupMap(interactableLookupMap);
                    continue;
                }
                if (!(component instanceof Interactable) || !((Interactable)component).isEnabled() || !((Interactable)component).isFocusable()) continue;
                interactableLookupMap.add((Interactable)component);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidate() {
        super.invalidate();
        List<Component> list = this.components;
        synchronized (list) {
            for (Component component : this.components) {
                component.invalidate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void layout(TerminalSize size) {
        List<Component> list = this.components;
        synchronized (list) {
            this.layoutManager.doLayout(size, this.components);
        }
    }
}

