/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui2.table;

import com.googlecode.lanterna.gui2.AbstractInteractableComponent;
import com.googlecode.lanterna.gui2.Interactable;
import com.googlecode.lanterna.gui2.table.DefaultTableCellRenderer;
import com.googlecode.lanterna.gui2.table.DefaultTableHeaderRenderer;
import com.googlecode.lanterna.gui2.table.DefaultTableRenderer;
import com.googlecode.lanterna.gui2.table.TableCellRenderer;
import com.googlecode.lanterna.gui2.table.TableHeaderRenderer;
import com.googlecode.lanterna.gui2.table.TableModel;
import com.googlecode.lanterna.gui2.table.TableRenderer;
import com.googlecode.lanterna.input.KeyStroke;
import java.util.List;

public class Table<V>
extends AbstractInteractableComponent<Table<V>> {
    private TableModel<V> tableModel;
    private TableModel.Listener<V> tableModelListener;
    private TableHeaderRenderer<V> tableHeaderRenderer;
    private TableCellRenderer<V> tableCellRenderer;
    private Runnable selectAction;
    private boolean cellSelection;
    private int visibleRows;
    private int visibleColumns;
    private int viewTopRow;
    private int viewLeftColumn;
    private int selectedRow;
    private int selectedColumn;
    private boolean escapeByArrowKey;

    public Table(String ... columnLabels) {
        if (columnLabels.length == 0) {
            throw new IllegalArgumentException("Table needs at least one column");
        }
        this.tableHeaderRenderer = new DefaultTableHeaderRenderer();
        this.tableCellRenderer = new DefaultTableCellRenderer();
        this.tableModel = new TableModel(columnLabels);
        this.selectAction = null;
        this.visibleColumns = 0;
        this.visibleRows = 0;
        this.viewTopRow = 0;
        this.viewLeftColumn = 0;
        this.cellSelection = false;
        this.selectedRow = 0;
        this.selectedColumn = -1;
        this.escapeByArrowKey = true;
        this.tableModelListener = new TableModel.Listener<V>(){

            @Override
            public void onRowAdded(TableModel<V> model, int index) {
                Table.this.invalidate();
            }

            @Override
            public void onRowRemoved(TableModel<V> model, int index, List<V> oldRow) {
                Table.this.invalidate();
            }

            @Override
            public void onColumnAdded(TableModel<V> model, int index) {
                Table.this.invalidate();
            }

            @Override
            public void onColumnRemoved(TableModel<V> model, int index, String oldHeader, List<V> oldColumn) {
                Table.this.invalidate();
            }

            @Override
            public void onCellChanged(TableModel<V> model, int row, int column, V oldValue, V newValue) {
                Table.this.invalidate();
            }
        };
        this.tableModel.addListener(this.tableModelListener);
    }

    public TableModel<V> getTableModel() {
        return this.tableModel;
    }

    public synchronized Table<V> setTableModel(TableModel<V> tableModel) {
        if (tableModel == null) {
            throw new IllegalArgumentException("Cannot assign a null TableModel");
        }
        this.tableModel.removeListener(this.tableModelListener);
        this.tableModel = tableModel;
        this.tableModel.addListener(this.tableModelListener);
        this.invalidate();
        return this;
    }

    public TableCellRenderer<V> getTableCellRenderer() {
        return this.tableCellRenderer;
    }

    public synchronized Table<V> setTableCellRenderer(TableCellRenderer<V> tableCellRenderer) {
        this.tableCellRenderer = tableCellRenderer;
        this.invalidate();
        return this;
    }

    public TableHeaderRenderer<V> getTableHeaderRenderer() {
        return this.tableHeaderRenderer;
    }

    public synchronized Table<V> setTableHeaderRenderer(TableHeaderRenderer<V> tableHeaderRenderer) {
        this.tableHeaderRenderer = tableHeaderRenderer;
        this.invalidate();
        return this;
    }

    public synchronized void setVisibleColumns(int visibleColumns) {
        this.visibleColumns = visibleColumns;
        this.invalidate();
    }

    public int getVisibleColumns() {
        return this.visibleColumns;
    }

    public synchronized void setVisibleRows(int visibleRows) {
        this.visibleRows = visibleRows;
        this.invalidate();
    }

    public int getVisibleRows() {
        return this.visibleRows;
    }

    public int getViewTopRow() {
        return this.viewTopRow;
    }

    public synchronized Table<V> setViewTopRow(int viewTopRow) {
        this.viewTopRow = viewTopRow;
        return this;
    }

    public int getViewLeftColumn() {
        return this.viewLeftColumn;
    }

    public synchronized Table<V> setViewLeftColumn(int viewLeftColumn) {
        this.viewLeftColumn = viewLeftColumn;
        return this;
    }

    public int getSelectedColumn() {
        return this.selectedColumn;
    }

    public synchronized Table<V> setSelectedColumn(int selectedColumn) {
        if (this.cellSelection) {
            this.selectedColumn = selectedColumn;
            this.ensureSelectedItemIsVisible();
        }
        return this;
    }

    public int getSelectedRow() {
        return this.selectedRow;
    }

    public synchronized Table<V> setSelectedRow(int selectedRow) {
        this.selectedRow = selectedRow;
        this.ensureSelectedItemIsVisible();
        return this;
    }

    public synchronized Table<V> setCellSelection(boolean cellSelection) {
        this.cellSelection = cellSelection;
        if (cellSelection && this.selectedColumn == -1) {
            this.selectedColumn = 0;
        } else if (!cellSelection) {
            this.selectedColumn = -1;
        }
        return this;
    }

    public boolean isCellSelection() {
        return this.cellSelection;
    }

    public synchronized Table<V> setSelectAction(Runnable selectAction) {
        this.selectAction = selectAction;
        return this;
    }

    public boolean isEscapeByArrowKey() {
        return this.escapeByArrowKey;
    }

    public synchronized Table<V> setEscapeByArrowKey(boolean escapeByArrowKey) {
        this.escapeByArrowKey = escapeByArrowKey;
        return this;
    }

    @Override
    protected TableRenderer<V> createDefaultRenderer() {
        return new DefaultTableRenderer();
    }

    @Override
    public TableRenderer<V> getRenderer() {
        return (TableRenderer)super.getRenderer();
    }

    @Override
    public Interactable.Result handleKeyStroke(KeyStroke keyStroke) {
        switch (keyStroke.getKeyType()) {
            case ArrowUp: {
                if (this.selectedRow > 0) {
                    --this.selectedRow;
                    break;
                }
                if (!this.escapeByArrowKey) break;
                return Interactable.Result.MOVE_FOCUS_UP;
            }
            case ArrowDown: {
                if (this.selectedRow < this.tableModel.getRowCount() - 1) {
                    ++this.selectedRow;
                    break;
                }
                if (!this.escapeByArrowKey) break;
                return Interactable.Result.MOVE_FOCUS_DOWN;
            }
            case ArrowLeft: {
                if (this.cellSelection && this.selectedColumn > 0) {
                    --this.selectedColumn;
                    break;
                }
                if (!this.escapeByArrowKey) break;
                return Interactable.Result.MOVE_FOCUS_LEFT;
            }
            case ArrowRight: {
                if (this.cellSelection && this.selectedColumn < this.tableModel.getColumnCount() - 1) {
                    ++this.selectedColumn;
                    break;
                }
                if (!this.escapeByArrowKey) break;
                return Interactable.Result.MOVE_FOCUS_RIGHT;
            }
            case Enter: {
                Runnable runnable = this.selectAction;
                if (runnable != null) {
                    runnable.run();
                    break;
                }
                return Interactable.Result.MOVE_FOCUS_NEXT;
            }
            default: {
                return super.handleKeyStroke(keyStroke);
            }
        }
        this.ensureSelectedItemIsVisible();
        this.invalidate();
        return Interactable.Result.HANDLED;
    }

    private void ensureSelectedItemIsVisible() {
        if (this.visibleRows > 0 && this.selectedRow < this.viewTopRow) {
            this.viewTopRow = this.selectedRow;
        } else if (this.visibleRows > 0 && this.selectedRow >= this.viewTopRow + this.visibleRows) {
            this.viewTopRow = Math.max(0, this.selectedRow - this.visibleRows + 1);
        }
        if (this.selectedColumn != -1) {
            if (this.visibleColumns > 0 && this.selectedColumn < this.viewLeftColumn) {
                this.viewLeftColumn = this.selectedColumn;
            } else if (this.visibleColumns > 0 && this.selectedColumn >= this.viewLeftColumn + this.visibleColumns) {
                this.viewLeftColumn = Math.max(0, this.selectedColumn - this.visibleColumns + 1);
            }
        }
    }
}

