/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.terminal.ansi;

import com.googlecode.lanterna.TerminalPosition;
import com.googlecode.lanterna.TerminalTextUtils;
import com.googlecode.lanterna.input.InputDecoder;
import com.googlecode.lanterna.input.KeyDecodingProfile;
import com.googlecode.lanterna.input.KeyStroke;
import com.googlecode.lanterna.input.ScreenInfoAction;
import com.googlecode.lanterna.input.ScreenInfoCharacterPattern;
import com.googlecode.lanterna.terminal.AbstractTerminal;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public abstract class StreamBasedTerminal
extends AbstractTerminal {
    private static final Charset UTF8_REFERENCE = Charset.forName("UTF-8");
    private final InputStream terminalInput;
    private final OutputStream terminalOutput;
    private final Charset terminalCharset;
    private final InputDecoder inputDecoder;
    private final Queue<KeyStroke> keyQueue;
    private final Lock readLock;
    private volatile TerminalPosition lastReportedCursorPosition;

    public StreamBasedTerminal(InputStream terminalInput, OutputStream terminalOutput, Charset terminalCharset) {
        this.terminalInput = terminalInput;
        this.terminalOutput = terminalOutput;
        this.terminalCharset = terminalCharset == null ? Charset.defaultCharset() : terminalCharset;
        this.inputDecoder = new InputDecoder(new InputStreamReader(this.terminalInput, this.terminalCharset));
        this.keyQueue = new LinkedList<KeyStroke>();
        this.readLock = new ReentrantLock();
        this.lastReportedCursorPosition = null;
    }

    @Override
    public void putCharacter(char c) throws IOException {
        if (TerminalTextUtils.isPrintableCharacter(c)) {
            this.writeToTerminal(this.translateCharacter(c));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeToTerminal(byte ... bytes) throws IOException {
        OutputStream outputStream = this.terminalOutput;
        synchronized (outputStream) {
            this.terminalOutput.write(bytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] enquireTerminal(int timeout, TimeUnit timeoutTimeUnit) throws IOException {
        OutputStream outputStream = this.terminalOutput;
        synchronized (outputStream) {
            this.terminalOutput.write(5);
            this.flush();
        }
        long startTime = System.currentTimeMillis();
        while (this.terminalInput.available() == 0) {
            if (System.currentTimeMillis() - startTime > timeoutTimeUnit.toMillis(timeout)) {
                return new byte[0];
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                return new byte[0];
            }
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        while (this.terminalInput.available() > 0) {
            buffer.write(this.terminalInput.read());
        }
        return buffer.toByteArray();
    }

    @Override
    public void bell() throws IOException {
        this.terminalOutput.write(7);
        this.terminalOutput.flush();
    }

    @Deprecated
    public void addKeyDecodingProfile(KeyDecodingProfile profile) {
        this.inputDecoder.addProfile(profile);
    }

    public InputDecoder getInputDecoder() {
        return this.inputDecoder;
    }

    void resetMemorizedCursorPosition() {
        this.lastReportedCursorPosition = null;
    }

    synchronized TerminalPosition waitForCursorPositionReport() throws IOException {
        long startTime = System.currentTimeMillis();
        TerminalPosition cursorPosition = this.lastReportedCursorPosition;
        while (cursorPosition == null) {
            if (System.currentTimeMillis() - startTime > 5000L) {
                return null;
            }
            KeyStroke keyStroke = this.readInput(false, false);
            if (keyStroke != null) {
                this.keyQueue.add(keyStroke);
            } else {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            cursorPosition = this.lastReportedCursorPosition;
        }
        return cursorPosition;
    }

    @Override
    public KeyStroke pollInput() throws IOException {
        return this.readInput(false, true);
    }

    @Override
    public KeyStroke readInput() throws IOException {
        return this.readInput(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyStroke readInput(boolean blocking, boolean useKeyQueue) throws IOException {
        KeyStroke previouslyReadKey;
        while (!useKeyQueue || (previouslyReadKey = this.keyQueue.poll()) == null) {
            if (blocking) {
                this.readLock.lock();
            } else if (!this.readLock.tryLock()) {
                return null;
            }
            try {
                KeyStroke key = this.inputDecoder.getNextCharacter(blocking);
                ScreenInfoAction report = ScreenInfoCharacterPattern.tryToAdopt(key);
                if (this.lastReportedCursorPosition == null && report != null) {
                    this.lastReportedCursorPosition = report.getPosition();
                    continue;
                }
                KeyStroke keyStroke = key;
                return keyStroke;
            }
            finally {
                this.readLock.unlock();
                continue;
            }
            break;
        }
        return previouslyReadKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        OutputStream outputStream = this.terminalOutput;
        synchronized (outputStream) {
            this.terminalOutput.flush();
        }
    }

    @Override
    public void close() throws IOException {
    }

    protected Charset getCharset() {
        return this.terminalCharset;
    }

    protected byte[] translateCharacter(char input) {
        if (UTF8_REFERENCE != null && UTF8_REFERENCE == this.terminalCharset) {
            return this.convertToCharset(input);
        }
        switch (input) {
            case '\u2193': {
                return this.convertToVT100('v');
            }
            case '\u2190': {
                return this.convertToVT100('<');
            }
            case '\u2192': {
                return this.convertToVT100('>');
            }
            case '\u2191': {
                return this.convertToVT100('^');
            }
            case '\u2588': 
            case '\u2591': 
            case '\u2592': 
            case '\u2593': {
                return this.convertToVT100('a');
            }
            case '\u2660': 
            case '\u2663': 
            case '\u2665': {
                return this.convertToVT100('?');
            }
            case '\u263a': 
            case '\u263b': 
            case '\u2666': {
                return this.convertToVT100('`');
            }
            case '\u2022': {
                return this.convertToVT100('f');
            }
            case '\u253c': 
            case '\u256c': {
                return this.convertToVT100('n');
            }
            case '\u2500': 
            case '\u2550': {
                return this.convertToVT100('q');
            }
            case '\u2514': 
            case '\u255a': {
                return this.convertToVT100('m');
            }
            case '\u2518': 
            case '\u255d': {
                return this.convertToVT100('j');
            }
            case '\u252c': 
            case '\u2564': 
            case '\u2565': 
            case '\u2566': {
                return this.convertToVT100('w');
            }
            case '\u2524': 
            case '\u2561': 
            case '\u2562': 
            case '\u2563': {
                return this.convertToVT100('u');
            }
            case '\u251c': 
            case '\u255e': 
            case '\u255f': 
            case '\u2560': {
                return this.convertToVT100('t');
            }
            case '\u2534': 
            case '\u2567': 
            case '\u2568': 
            case '\u2569': {
                return this.convertToVT100('v');
            }
            case '\u250c': 
            case '\u2554': {
                return this.convertToVT100('l');
            }
            case '\u2510': 
            case '\u2557': {
                return this.convertToVT100('k');
            }
            case '\u2502': 
            case '\u2551': {
                return this.convertToVT100('x');
            }
        }
        return this.convertToCharset(input);
    }

    private byte[] convertToVT100(char code) {
        return new byte[]{27, 40, 48, (byte)code, 27, 40, 66};
    }

    private byte[] convertToCharset(char input) {
        return this.terminalCharset.encode(Character.toString(input)).array();
    }
}

