/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.terminal.swing;

import com.googlecode.lanterna.SGR;
import com.googlecode.lanterna.TerminalPosition;
import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.TextColor;
import com.googlecode.lanterna.graphics.TextGraphics;
import com.googlecode.lanterna.input.KeyStroke;
import com.googlecode.lanterna.terminal.IOSafeTerminal;
import com.googlecode.lanterna.terminal.TerminalResizeListener;
import com.googlecode.lanterna.terminal.swing.SwingTerminal;
import com.googlecode.lanterna.terminal.swing.SwingTerminalFontConfiguration;
import com.googlecode.lanterna.terminal.swing.TerminalEmulatorColorConfiguration;
import com.googlecode.lanterna.terminal.swing.TerminalEmulatorDeviceConfiguration;
import com.googlecode.lanterna.terminal.swing.TerminalScrollController;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;

public class ScrollingSwingTerminal
extends JComponent
implements IOSafeTerminal {
    private final SwingTerminal swingTerminal;
    private final JScrollBar scrollBar = new JScrollBar(1);
    private volatile boolean scrollModelUpdateBySystem;

    public ScrollingSwingTerminal() {
        this(TerminalEmulatorDeviceConfiguration.getDefault(), SwingTerminalFontConfiguration.getDefault(), TerminalEmulatorColorConfiguration.getDefault());
    }

    public ScrollingSwingTerminal(TerminalEmulatorDeviceConfiguration deviceConfiguration, SwingTerminalFontConfiguration fontConfiguration, TerminalEmulatorColorConfiguration colorConfiguration) {
        this.swingTerminal = new SwingTerminal(deviceConfiguration, fontConfiguration, colorConfiguration, new ScrollController());
        this.setLayout(new BorderLayout());
        this.add((Component)this.swingTerminal, "Center");
        this.add((Component)this.scrollBar, "East");
        this.scrollBar.setMinimum(0);
        this.scrollBar.setMaximum(20);
        this.scrollBar.setValue(0);
        this.scrollBar.setVisibleAmount(20);
        this.scrollBar.addAdjustmentListener(new ScrollbarListener());
        this.scrollModelUpdateBySystem = false;
    }

    @Override
    public KeyStroke pollInput() {
        return this.swingTerminal.pollInput();
    }

    @Override
    public KeyStroke readInput() {
        return this.swingTerminal.readInput();
    }

    @Override
    public void enterPrivateMode() {
        this.swingTerminal.enterPrivateMode();
    }

    @Override
    public void exitPrivateMode() {
        this.swingTerminal.exitPrivateMode();
    }

    @Override
    public void clearScreen() {
        this.swingTerminal.clearScreen();
    }

    @Override
    public void setCursorPosition(int x, int y) {
        this.swingTerminal.setCursorPosition(x, y);
    }

    @Override
    public void setCursorPosition(TerminalPosition position) {
        this.swingTerminal.setCursorPosition(position);
    }

    @Override
    public TerminalPosition getCursorPosition() {
        return this.swingTerminal.getCursorPosition();
    }

    @Override
    public void setCursorVisible(boolean visible) {
        this.swingTerminal.setCursorVisible(visible);
    }

    @Override
    public void putCharacter(char c) {
        this.swingTerminal.putCharacter(c);
    }

    @Override
    public TextGraphics newTextGraphics() {
        return this.swingTerminal.newTextGraphics();
    }

    @Override
    public void enableSGR(SGR sgr) {
        this.swingTerminal.enableSGR(sgr);
    }

    @Override
    public void disableSGR(SGR sgr) {
        this.swingTerminal.disableSGR(sgr);
    }

    @Override
    public void resetColorAndSGR() {
        this.swingTerminal.resetColorAndSGR();
    }

    @Override
    public void setForegroundColor(TextColor color) {
        this.swingTerminal.setForegroundColor(color);
    }

    @Override
    public void setBackgroundColor(TextColor color) {
        this.swingTerminal.setBackgroundColor(color);
    }

    @Override
    public TerminalSize getTerminalSize() {
        return this.swingTerminal.getTerminalSize();
    }

    @Override
    public byte[] enquireTerminal(int timeout, TimeUnit timeoutUnit) {
        return this.swingTerminal.enquireTerminal(timeout, timeoutUnit);
    }

    @Override
    public void bell() {
        this.swingTerminal.bell();
    }

    @Override
    public void flush() {
        this.swingTerminal.flush();
    }

    @Override
    public void close() {
        this.swingTerminal.close();
    }

    @Override
    public void addResizeListener(TerminalResizeListener listener) {
        this.swingTerminal.addResizeListener(listener);
    }

    @Override
    public void removeResizeListener(TerminalResizeListener listener) {
        this.swingTerminal.removeResizeListener(listener);
    }

    private class ScrollbarListener
    implements AdjustmentListener {
        private ScrollbarListener() {
        }

        @Override
        public synchronized void adjustmentValueChanged(AdjustmentEvent e) {
            if (!ScrollingSwingTerminal.this.scrollModelUpdateBySystem) {
                ScrollingSwingTerminal.this.swingTerminal.repaint();
            }
        }
    }

    private class ScrollController
    implements TerminalScrollController {
        private int scrollValue;

        private ScrollController() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void updateModel(final int totalSize, final int screenHeight) {
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ScrollController.this.updateModel(totalSize, screenHeight);
                    }
                });
                return;
            }
            try {
                ScrollingSwingTerminal.this.scrollModelUpdateBySystem = true;
                int value = ScrollingSwingTerminal.this.scrollBar.getValue();
                int maximum = ScrollingSwingTerminal.this.scrollBar.getMaximum();
                int visibleAmount = ScrollingSwingTerminal.this.scrollBar.getVisibleAmount();
                if (maximum != totalSize) {
                    int lastMaximum = maximum;
                    int n = maximum = totalSize > screenHeight ? totalSize : screenHeight;
                    if (lastMaximum < maximum && lastMaximum - visibleAmount - value == 0) {
                        value = ScrollingSwingTerminal.this.scrollBar.getValue() + (maximum - lastMaximum);
                    }
                }
                if (value + screenHeight > maximum) {
                    value = maximum - screenHeight;
                }
                if (visibleAmount != screenHeight) {
                    if (visibleAmount > screenHeight) {
                        value += visibleAmount - screenHeight;
                    }
                    visibleAmount = screenHeight;
                }
                if (value > maximum - visibleAmount) {
                    value = maximum - visibleAmount;
                }
                if (value < 0) {
                    value = 0;
                }
                this.scrollValue = value;
                if (ScrollingSwingTerminal.this.scrollBar.getMaximum() != maximum) {
                    ScrollingSwingTerminal.this.scrollBar.setMaximum(maximum);
                }
                if (ScrollingSwingTerminal.this.scrollBar.getVisibleAmount() != visibleAmount) {
                    ScrollingSwingTerminal.this.scrollBar.setVisibleAmount(visibleAmount);
                }
                if (ScrollingSwingTerminal.this.scrollBar.getValue() != value) {
                    ScrollingSwingTerminal.this.scrollBar.setValue(value);
                }
            }
            finally {
                ScrollingSwingTerminal.this.scrollModelUpdateBySystem = false;
            }
        }

        @Override
        public int getScrollingOffset() {
            return this.scrollValue;
        }
    }
}

