/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.terminal.swing;

import com.googlecode.lanterna.TextColor;

public class TerminalEmulatorDeviceConfiguration {
    private final int lineBufferScrollbackSize;
    private final int blinkLengthInMilliSeconds;
    private final CursorStyle cursorStyle;
    private final TextColor cursorColor;
    private final boolean cursorBlinking;
    private final boolean clipboardAvailable;

    public static TerminalEmulatorDeviceConfiguration getDefault() {
        return new TerminalEmulatorDeviceConfiguration();
    }

    public TerminalEmulatorDeviceConfiguration() {
        this(2000, 500, CursorStyle.REVERSED, new TextColor.RGB(255, 255, 255), false, true);
    }

    public TerminalEmulatorDeviceConfiguration(int lineBufferScrollbackSize, int blinkLengthInMilliSeconds, CursorStyle cursorStyle, TextColor cursorColor, boolean cursorBlinking) {
        this(lineBufferScrollbackSize, blinkLengthInMilliSeconds, cursorStyle, cursorColor, cursorBlinking, true);
    }

    public TerminalEmulatorDeviceConfiguration(int lineBufferScrollbackSize, int blinkLengthInMilliSeconds, CursorStyle cursorStyle, TextColor cursorColor, boolean cursorBlinking, boolean clipboardAvailable) {
        this.lineBufferScrollbackSize = lineBufferScrollbackSize;
        this.blinkLengthInMilliSeconds = blinkLengthInMilliSeconds;
        this.cursorStyle = cursorStyle;
        this.cursorColor = cursorColor;
        this.cursorBlinking = cursorBlinking;
        this.clipboardAvailable = clipboardAvailable;
    }

    public int getBlinkLengthInMilliSeconds() {
        return this.blinkLengthInMilliSeconds;
    }

    public int getLineBufferScrollbackSize() {
        return this.lineBufferScrollbackSize;
    }

    public CursorStyle getCursorStyle() {
        return this.cursorStyle;
    }

    public TextColor getCursorColor() {
        return this.cursorColor;
    }

    public boolean isCursorBlinking() {
        return this.cursorBlinking;
    }

    public boolean isClipboardAvailable() {
        return this.clipboardAvailable;
    }

    public TerminalEmulatorDeviceConfiguration withLineBufferScrollbackSize(int lineBufferScrollbackSize) {
        if (this.lineBufferScrollbackSize == lineBufferScrollbackSize) {
            return this;
        }
        return new TerminalEmulatorDeviceConfiguration(lineBufferScrollbackSize, this.blinkLengthInMilliSeconds, this.cursorStyle, this.cursorColor, this.cursorBlinking);
    }

    public static enum CursorStyle {
        REVERSED,
        FIXED_BACKGROUND,
        UNDER_BAR,
        VERTICAL_BAR;

    }
}

