/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.terminal.virtual;

import com.googlecode.lanterna.TerminalPosition;
import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.TextCharacter;
import com.googlecode.lanterna.graphics.AbstractTextGraphics;
import com.googlecode.lanterna.graphics.TextGraphics;
import com.googlecode.lanterna.terminal.virtual.DefaultVirtualTerminal;

class VirtualTerminalTextGraphics
extends AbstractTextGraphics {
    private final DefaultVirtualTerminal virtualTerminal;

    VirtualTerminalTextGraphics(DefaultVirtualTerminal virtualTerminal) {
        this.virtualTerminal = virtualTerminal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TextGraphics setCharacter(int columnIndex, int rowIndex, TextCharacter textCharacter) {
        TerminalSize size = this.getSize();
        if (columnIndex < 0 || columnIndex >= size.getColumns() || rowIndex < 0 || rowIndex >= size.getRows()) {
            return this;
        }
        DefaultVirtualTerminal defaultVirtualTerminal = this.virtualTerminal;
        synchronized (defaultVirtualTerminal) {
            this.virtualTerminal.setCursorPosition(new TerminalPosition(columnIndex, rowIndex));
            this.virtualTerminal.putCharacter(textCharacter);
        }
        return this;
    }

    @Override
    public TextCharacter getCharacter(TerminalPosition position) {
        return this.virtualTerminal.getCharacter(position);
    }

    @Override
    public TextCharacter getCharacter(int column, int row) {
        return this.getCharacter(new TerminalPosition(column, row));
    }

    @Override
    public TerminalSize getSize() {
        return this.virtualTerminal.getTerminalSize();
    }
}

