/*
 * Decompiled with CFR 0.152.
 */
package net.filebot;

import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.StandardOpenOption;
import java.util.Scanner;
import java.util.logging.Level;
import net.filebot.ApplicationFolder;
import net.filebot.Cache;
import net.filebot.CacheType;
import net.filebot.Logging;
import net.filebot.Settings;
import net.filebot.util.FileUtilities;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.DiskStoreConfiguration;

public class CacheManager {
    private static final CacheManager instance = new CacheManager();
    private final File diskStore;
    private final net.sf.ehcache.CacheManager manager;

    public static CacheManager getInstance() {
        return instance;
    }

    public CacheManager() {
        try {
            this.diskStore = this.acquireDiskStore();
            this.manager = net.sf.ehcache.CacheManager.create(new Configuration().diskStore(new DiskStoreConfiguration().path(this.diskStore.getPath())));
        }
        catch (IOException e) {
            throw new CacheException(e);
        }
    }

    public synchronized Cache getCache(String name, CacheType type) {
        if (!this.manager.cacheExists(name)) {
            this.manager.addCache(new net.sf.ehcache.Cache(type.getConfiguration(name)));
        }
        return new Cache(this.manager.getCache(name), type);
    }

    public synchronized void clearAll() {
        this.manager.clearAll();
        this.clearDiskStore(this.diskStore);
    }

    public synchronized void shutdown() {
        this.manager.shutdown();
    }

    private void clearDiskStore(File cache) {
        FileUtilities.getChildren(cache, FileUtilities.FILES).stream().filter(f -> !f.getName().startsWith(".")).forEach(f -> {
            try {
                FileUtilities.delete(f);
            }
            catch (Exception e) {
                Logging.debug.warning(Logging.format("Failed to delete cache: %s => %s", f, e));
            }
        });
    }

    private File acquireDiskStore() throws IOException {
        for (int i = 0; i < 10; ++i) {
            File cache = ApplicationFolder.Cache.resolve(String.valueOf(i));
            FileUtilities.createFolders(cache);
            File lockFile = new File(cache, ".lock");
            boolean isNewCache = !lockFile.exists();
            FileChannel channel = FileChannel.open(lockFile.toPath(), StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);
            FileLock lock = channel.tryLock();
            if (lock != null) {
                Logging.debug.config(Logging.format("Using persistent disk cache %s", cache));
                int applicationRevision = Settings.getApplicationRevisionNumber();
                int cacheRevision = 0;
                if (channel.size() > 0L) {
                    try {
                        cacheRevision = new Scanner((ReadableByteChannel)channel, "UTF-8").nextInt();
                    }
                    catch (Exception e) {
                        Logging.debug.log(Level.WARNING, e, e::toString);
                    }
                }
                if (cacheRevision != applicationRevision && applicationRevision > 0 && !isNewCache) {
                    Logging.debug.config(Logging.format("Current application version (r%d) does not match cache version (r%d): reset cache", applicationRevision, cacheRevision));
                    isNewCache = true;
                    this.clearDiskStore(cache);
                }
                if (isNewCache) {
                    channel.position(0L);
                    channel.write(StandardCharsets.UTF_8.encode(String.valueOf(applicationRevision)));
                    channel.truncate(channel.position());
                }
                Runtime.getRuntime().addShutdownHook(new ShutdownHook(this, channel, lock));
                return cache;
            }
            channel.close();
        }
        throw new IOException("Unable to acquire cache lock: " + ApplicationFolder.Cache.get().getAbsolutePath());
    }

    private static class ShutdownHook
    extends Thread {
        private final CacheManager manager;
        private final FileChannel channel;
        private final FileLock lock;

        public ShutdownHook(CacheManager manager, FileChannel channel, FileLock lock) {
            this.manager = manager;
            this.channel = channel;
            this.lock = lock;
        }

        @Override
        public void run() {
            try {
                this.manager.shutdown();
            }
            catch (Exception e) {
                Logging.debug.log(Level.WARNING, "Shutdown hook failed: shutdown", e);
            }
            try {
                this.lock.release();
            }
            catch (Exception e) {
                Logging.debug.log(Level.WARNING, "Shutdown hook failed: release", e);
            }
            try {
                this.channel.close();
            }
            catch (Exception e) {
                Logging.debug.log(Level.WARNING, "Shutdown hook failed: close", e);
            }
        }
    }
}

