/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.archive;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import net.filebot.archive.ExtractOutProvider;
import net.filebot.archive.ExtractOutStream;
import net.sf.sevenzipjbinding.ExtractAskMode;
import net.sf.sevenzipjbinding.ExtractOperationResult;
import net.sf.sevenzipjbinding.IArchiveExtractCallback;
import net.sf.sevenzipjbinding.IInArchive;
import net.sf.sevenzipjbinding.ISequentialOutStream;
import net.sf.sevenzipjbinding.PropID;
import net.sf.sevenzipjbinding.SevenZipException;

class ExtractCallback
implements IArchiveExtractCallback {
    private IInArchive inArchive;
    private ExtractOutProvider extractOut;
    private ExtractOutStream output = null;

    public ExtractCallback(IInArchive inArchive, ExtractOutProvider extractOut) {
        this.inArchive = inArchive;
        this.extractOut = extractOut;
    }

    @Override
    public ISequentialOutStream getStream(int index, ExtractAskMode extractAskMode) throws SevenZipException {
        if (extractAskMode != ExtractAskMode.EXTRACT) {
            return null;
        }
        boolean isFolder = (Boolean)this.inArchive.getProperty(index, PropID.IS_FOLDER);
        if (isFolder) {
            return null;
        }
        String path = (String)this.inArchive.getProperty(index, PropID.PATH);
        try {
            OutputStream target = this.extractOut.getStream(new File(path));
            if (target == null) {
                return null;
            }
            this.output = new ExtractOutStream(target);
            return this.output;
        }
        catch (IOException e) {
            throw new SevenZipException(e);
        }
    }

    @Override
    public void prepareOperation(ExtractAskMode extractAskMode) throws SevenZipException {
    }

    @Override
    public void setOperationResult(ExtractOperationResult extractOperationResult) throws SevenZipException {
        if (this.output != null) {
            try {
                this.output.close();
            }
            catch (IOException e) {
                throw new SevenZipException(e);
            }
            finally {
                this.output = null;
            }
        }
        if (extractOperationResult != ExtractOperationResult.OK) {
            throw new SevenZipException("Extraction Error: " + (Object)((Object)extractOperationResult));
        }
    }

    @Override
    public void setCompleted(long completeValue) throws SevenZipException {
    }

    @Override
    public void setTotal(long total) throws SevenZipException {
    }
}

