/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.archive;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.filebot.archive.ExtractOutProvider;

public class FileMapper
implements ExtractOutProvider {
    private File outputDir;
    private boolean flatten;

    public FileMapper(File outputDir) {
        this(outputDir, false);
    }

    public FileMapper(File outputDir, boolean flatten) {
        this.outputDir = outputDir;
        this.flatten = flatten;
    }

    public File getOutputDir() {
        return this.outputDir;
    }

    public File getOutputFile(File entry) {
        return new File(this.outputDir, this.flatten ? entry.getName() : entry.getPath());
    }

    @Override
    public OutputStream getStream(File entry) throws IOException {
        File outputFile = this.getOutputFile(entry);
        File outputFolder = outputFile.getParentFile();
        if (!outputFolder.isDirectory() && !outputFolder.mkdirs()) {
            throw new IOException("Failed to create folder: " + outputFolder);
        }
        return new FileOutputStream(outputFile);
    }
}

