/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.archive;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import net.filebot.Logging;
import net.filebot.archive.ArchiveExtractor;
import net.filebot.util.ByteBufferOutputStream;
import net.filebot.util.RegularExpressions;
import net.filebot.vfs.FileInfo;
import net.filebot.vfs.SimpleFileInfo;

public class SevenZipExecutable
implements ArchiveExtractor {
    private File archive;

    public SevenZipExecutable(File file) throws Exception {
        if (!file.exists()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        this.archive = file.getCanonicalFile();
    }

    protected String get7zCommand() {
        return System.getProperty("net.filebot.Archive.7z", "7z");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected CharSequence execute(String ... command) throws IOException {
        Process process = new ProcessBuilder(command).redirectError(ProcessBuilder.Redirect.INHERIT).start();
        try (ByteBufferOutputStream bb = new ByteBufferOutputStream(8192);){
            bb.transferFully(process.getInputStream());
            int returnCode = process.waitFor();
            String output = StandardCharsets.UTF_8.decode(bb.getByteBuffer()).toString();
            Logging.debug.fine(Logging.format("Execute: %s", Arrays.asList(command)));
            Logging.debug.finest(output);
            if (returnCode == 0) {
                String string = output;
                return string;
            }
            throw new IOException(String.format("%s failed with exit code %d: %s", this.get7zCommand(), returnCode, RegularExpressions.SPACE.matcher(output).replaceAll(" ").trim()));
        }
        catch (InterruptedException e) {
            throw new IOException(String.format("%s timed out", this.get7zCommand()), e);
        }
    }

    @Override
    public List<FileInfo> listFiles() throws IOException {
        CharSequence output = this.execute(this.get7zCommand(), "l", "-slt", "-y", this.archive.getPath());
        ArrayList<FileInfo> paths = new ArrayList<FileInfo>();
        String path = null;
        long size = -1L;
        for (String line : RegularExpressions.NEWLINE.split(output)) {
            int split = line.indexOf(" = ");
            if (split < 0) continue;
            String key = line.substring(0, split);
            String value = line.substring(split + 3, line.length());
            if (key.isEmpty() || value.isEmpty()) continue;
            if ("Path".equals(key)) {
                path = value;
            } else if ("Size".equals(key)) {
                size = Long.parseLong(value);
            }
            if (path == null || size < 0L) continue;
            paths.add(new SimpleFileInfo(path, size));
            path = null;
            size = -1L;
        }
        return paths;
    }

    @Override
    public void extract(File outputDir) throws IOException {
        this.execute(this.get7zCommand(), "x", "-y", "-aos", this.archive.getPath(), "-o" + outputDir.getCanonicalPath());
    }

    @Override
    public void extract(File outputDir, FileFilter filter) throws IOException {
        Stream<String> command = Stream.of(this.get7zCommand(), "x", "-y", "-aos", this.archive.getPath(), "-o" + outputDir.getCanonicalPath());
        Stream<String> selection = this.listFiles().stream().filter(f -> filter.accept(f.toFile())).map(f -> f.getPath());
        this.execute((String[])Stream.concat(command, selection).toArray(String[]::new));
    }
}

