/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.archive;

import net.sf.sevenzipjbinding.IArchiveOpenCallback;
import net.sf.sevenzipjbinding.IInArchive;
import net.sf.sevenzipjbinding.IInStream;
import net.sf.sevenzipjbinding.SevenZip;
import net.sf.sevenzipjbinding.SevenZipException;
import net.sf.sevenzipjbinding.SevenZipNativeInitializationException;

public class SevenZipLoader {
    private static boolean nativeLibrariesLoaded = false;

    private static synchronized void requireNativeLibraries() throws SevenZipNativeInitializationException {
        if (nativeLibrariesLoaded) {
            return;
        }
        try {
            System.loadLibrary("7-Zip-JBinding");
            SevenZip.initLoadedLibraries();
            nativeLibrariesLoaded = true;
        }
        catch (Throwable e) {
            throw new SevenZipNativeInitializationException("Failed to load 7z-JBinding: " + e.getMessage(), e);
        }
    }

    public static String getNativeVersion() throws SevenZipNativeInitializationException {
        SevenZipLoader.requireNativeLibraries();
        return SevenZip.getSevenZipVersion().version;
    }

    public static IInArchive open(IInStream stream, IArchiveOpenCallback callback) throws SevenZipException, SevenZipNativeInitializationException {
        SevenZipLoader.requireNativeLibraries();
        return callback == null ? SevenZip.openInArchive(null, stream) : SevenZip.openInArchive(null, stream, callback);
    }
}

