/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.cli;

import java.io.File;
import java.io.FileFilter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.logging.Level;
import net.filebot.ApplicationFolder;
import net.filebot.Language;
import net.filebot.Logging;
import net.filebot.StandardRenameAction;
import net.filebot.WebServices;
import net.filebot.cli.BindingsHandler;
import net.filebot.cli.CmdlineException;
import net.filebot.cli.ConflictAction;
import net.filebot.format.ExpressionFileFilter;
import net.filebot.format.ExpressionFileFormat;
import net.filebot.format.ExpressionFilter;
import net.filebot.format.ExpressionFormat;
import net.filebot.hash.HashType;
import net.filebot.hash.VerificationUtilities;
import net.filebot.subtitle.SubtitleFormat;
import net.filebot.subtitle.SubtitleNaming;
import net.filebot.subtitle.SubtitleUtilities;
import net.filebot.util.FileUtilities;
import net.filebot.web.Datasource;
import net.filebot.web.EpisodeListProvider;
import net.filebot.web.SortOrder;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.ParserProperties;
import org.kohsuke.args4j.spi.ExplicitBooleanOptionHandler;

public class ArgumentBean {
    @Option(name="--mode", usage="Open GUI in single panel mode / Enable CLI interactive mode", metaVar="[Rename, Subtitles, SFV] or [interactive]")
    public String mode = null;
    @Option(name="-rename", usage="Rename media files")
    public boolean rename = false;
    @Option(name="--db", usage="Database", metaVar="[TheTVDB, AniDB] or [TheMovieDB] or [AcoustID, ID3] or [xattr]")
    public String db;
    @Option(name="--order", usage="Episode order", metaVar="[Airdate, Absolute, DVD]")
    public String order = "Airdate";
    @Option(name="--action", usage="Rename action", metaVar="[move, copy, keeplink, symlink, hardlink, reflink, test]")
    public String action = "move";
    @Option(name="--conflict", usage="Conflict resolution", metaVar="[skip, override, auto, index, fail]")
    public String conflict = "skip";
    @Option(name="--filter", usage="Filter expression", metaVar="expression")
    public String filter = null;
    @Option(name="--format", usage="Format expression", metaVar="expression")
    public String format;
    @Option(name="-non-strict", usage="Enable advanced matching and more aggressive guessing")
    public boolean nonStrict = false;
    @Option(name="-get-subtitles", usage="Fetch subtitles")
    public boolean getSubtitles;
    @Option(name="--q", usage="Force lookup query", metaVar="series/movie title")
    public String query;
    @Option(name="--lang", usage="Language", metaVar="3-letter language code")
    public String lang = "en";
    @Option(name="-check", usage="Create/Check verification files")
    public boolean check;
    @Option(name="--output", usage="Output path", metaVar="/path")
    public String output;
    @Option(name="--encoding", usage="Output character encoding", metaVar="[UTF-8, Windows-1252]")
    public String encoding;
    @Option(name="-list", usage="Fetch episode list")
    public boolean list = false;
    @Option(name="-mediainfo", usage="Get media info")
    public boolean mediaInfo = false;
    @Option(name="-revert", usage="Revert files")
    public boolean revert = false;
    @Option(name="-extract", usage="Extract archives")
    public boolean extract = false;
    @Option(name="-script", usage="Run Groovy script", metaVar="[fn:name] or [dev:name] or [/path/to/script.groovy]")
    public String script = null;
    @Option(name="--log", usage="Log level", metaVar="[all, fine, info, warning]")
    public String log = "all";
    @Option(name="--log-file", usage="Log file", metaVar="/path/to/log.txt")
    public String logFile = null;
    @Option(name="--log-lock", usage="Lock log file", metaVar="[yes, no]", handler=ExplicitBooleanOptionHandler.class)
    public boolean logLock = true;
    @Option(name="-r", usage="Recursively process folders")
    public boolean recursive = false;
    @Option(name="-clear-cache", usage="Clear cached and temporary data")
    public boolean clearCache = false;
    @Option(name="-clear-prefs", usage="Clear application settings")
    public boolean clearPrefs = false;
    @Option(name="-unixfs", usage="Do not strip invalid characters from file paths")
    public boolean unixfs = false;
    @Option(name="-no-xattr", usage="Disable extended attributes")
    public boolean disableExtendedAttributes = false;
    @Option(name="-version", usage="Print version identifier")
    public boolean version = false;
    @Option(name="-help", usage="Print this help message")
    public boolean help = false;
    @Option(name="--def", usage="Define script variables", handler=BindingsHandler.class)
    public Map<String, String> defines = new LinkedHashMap<String, String>();
    @Argument
    public List<String> arguments = new ArrayList<String>();
    private final String[] args;

    public boolean runCLI() {
        return this.rename || this.getSubtitles || this.check || this.list || this.mediaInfo || this.revert || this.extract || this.script != null;
    }

    public boolean isInteractive() {
        return "interactive".equalsIgnoreCase(this.mode) && System.console() != null;
    }

    public boolean printVersion() {
        return this.version;
    }

    public boolean printHelp() {
        return this.help;
    }

    public boolean clearCache() {
        return this.clearCache;
    }

    public boolean clearUserData() {
        return this.clearPrefs;
    }

    public List<File> getFiles(boolean resolveFolders) {
        if (this.arguments == null || this.arguments.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<File> files = new ArrayList<File>();
        for (String it : this.arguments) {
            if (it.trim().isEmpty()) continue;
            File file = new File(it);
            try {
                file = file.toPath().toRealPath(LinkOption.NOFOLLOW_LINKS).toFile();
            }
            catch (Exception e) {
                Logging.debug.warning(Logging.format("Illegal Argument: %s (%s)", e, file));
            }
            if (resolveFolders && file.isDirectory()) {
                if (this.recursive) {
                    files.addAll(FileUtilities.listFiles(file, FileUtilities.FILES, FileUtilities.HUMAN_NAME_ORDER));
                    continue;
                }
                files.addAll(FileUtilities.getChildren(file, f -> f.isFile() && !f.isHidden(), FileUtilities.HUMAN_NAME_ORDER));
                continue;
            }
            files.add(file);
        }
        return files;
    }

    public StandardRenameAction getRenameAction() {
        return StandardRenameAction.forName(this.action);
    }

    public ConflictAction getConflictAction() {
        return ConflictAction.forName(this.conflict);
    }

    public SortOrder getSortOrder() {
        return SortOrder.forName(this.order);
    }

    public ExpressionFormat getExpressionFormat() throws Exception {
        return this.format == null ? null : new ExpressionFormat(this.format);
    }

    public ExpressionFileFormat getExpressionFileFormat() throws Exception {
        return this.format == null ? null : new ExpressionFileFormat(this.format);
    }

    public ExpressionFilter getExpressionFilter() throws Exception {
        return this.filter == null ? null : new ExpressionFilter(this.filter);
    }

    public FileFilter getFileFilter() throws Exception {
        return this.filter == null ? FileUtilities.FILES : new ExpressionFileFilter(this.filter);
    }

    public Datasource getDatasource() {
        return this.db == null ? null : WebServices.getService(this.db);
    }

    public EpisodeListProvider getEpisodeListProvider() {
        return this.db == null ? WebServices.TheTVDB : WebServices.getEpisodeListProvider(this.db);
    }

    public String getSearchQuery() {
        return this.query == null || this.query.isEmpty() ? null : this.query;
    }

    public File getOutputPath() {
        return this.output == null ? null : new File(this.output);
    }

    public File getAbsoluteOutputFolder() throws Exception {
        return this.output == null ? null : new File(this.output).getCanonicalFile();
    }

    public SubtitleFormat getSubtitleOutputFormat() {
        return this.output == null ? null : SubtitleUtilities.getSubtitleFormatByName(this.output);
    }

    public SubtitleNaming getSubtitleNamingFormat() {
        return ArgumentBean.optional(this.format).map(SubtitleNaming::forName).orElse(SubtitleNaming.MATCH_VIDEO_ADD_LANGUAGE_TAG);
    }

    public HashType getOutputHashType() {
        return ArgumentBean.optional(this.output).map(File::new).map(f -> VerificationUtilities.getHashType(f)).orElseGet(() -> ArgumentBean.optional(this.format).map(k -> VerificationUtilities.getHashTypeByExtension(k)).orElse(HashType.SFV));
    }

    public Charset getEncoding() {
        return this.encoding == null ? null : Charset.forName(this.encoding);
    }

    public Language getLanguage() {
        return ArgumentBean.optional(this.lang).map(Language::findLanguage).orElseThrow(ArgumentBean.error("Illegal language code", this.lang));
    }

    public File getLogFile() {
        File file = new File(this.logFile);
        if (file.isAbsolute()) {
            return file;
        }
        return ApplicationFolder.AppData.resolve("logs/" + this.logFile);
    }

    public boolean isStrict() {
        return !this.nonStrict;
    }

    public Level getLogLevel() {
        return Level.parse(this.log.toUpperCase());
    }

    public ArgumentBean(String ... args) throws CmdLineException {
        this.args = args;
        CmdLineParser parser = new CmdLineParser(this);
        parser.parseArgument(args);
    }

    public String[] getArgumentArray() {
        return (String[])this.args.clone();
    }

    public String usage() {
        StringWriter buffer = new StringWriter();
        CmdLineParser parser = new CmdLineParser(this, ParserProperties.defaults().withShowDefaults(false).withOptionSorter(null));
        parser.printUsage(buffer, null);
        return buffer.toString();
    }

    private static <T> Optional<T> optional(T value) {
        return Optional.ofNullable(value);
    }

    private static Supplier<CmdlineException> error(String message, Object value) {
        return () -> new CmdlineException(message + ": " + value);
    }
}

