/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.cli;

import com.googlecode.lanterna.TextColor;
import com.googlecode.lanterna.bundle.LanternaThemes;
import com.googlecode.lanterna.gui2.BasicWindow;
import com.googlecode.lanterna.gui2.Button;
import com.googlecode.lanterna.gui2.CheckBoxList;
import com.googlecode.lanterna.gui2.Component;
import com.googlecode.lanterna.gui2.DefaultWindowManager;
import com.googlecode.lanterna.gui2.Direction;
import com.googlecode.lanterna.gui2.EmptySpace;
import com.googlecode.lanterna.gui2.GridLayout;
import com.googlecode.lanterna.gui2.LocalizedString;
import com.googlecode.lanterna.gui2.MultiWindowTextGUI;
import com.googlecode.lanterna.gui2.Panel;
import com.googlecode.lanterna.gui2.Panels;
import com.googlecode.lanterna.gui2.Separator;
import com.googlecode.lanterna.gui2.Window;
import com.googlecode.lanterna.gui2.dialogs.ListSelectDialog;
import com.googlecode.lanterna.gui2.dialogs.ListSelectDialogBuilder;
import com.googlecode.lanterna.screen.Screen;
import com.googlecode.lanterna.screen.TerminalScreen;
import com.googlecode.lanterna.terminal.DefaultTerminalFactory;
import com.googlecode.lanterna.terminal.Terminal;
import com.googlecode.lanterna.terminal.swing.TerminalEmulatorAutoCloseTrigger;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.filebot.RenameAction;
import net.filebot.cli.CmdlineOperations;
import net.filebot.cli.ConflictAction;
import net.filebot.media.MediaDetection;
import net.filebot.similarity.Match;
import net.filebot.web.SearchResult;

public class CmdlineOperationsTextUI
extends CmdlineOperations {
    public static final String DEFAULT_THEME = "businessmachine";
    private Terminal terminal = new DefaultTerminalFactory().setTerminalEmulatorFrameAutoCloseTrigger(TerminalEmulatorAutoCloseTrigger.CloseOnEscape).createTerminal();
    private Screen screen = new TerminalScreen(this.terminal);
    private MultiWindowTextGUI ui = new MultiWindowTextGUI(this.screen, new DefaultWindowManager(), new EmptySpace(TextColor.ANSI.DEFAULT));

    public CmdlineOperationsTextUI() throws Exception {
        this.ui.setTheme(LanternaThemes.getRegisteredTheme(DEFAULT_THEME));
    }

    public synchronized <T> T onScreen(Supplier<T> dialog) throws Exception {
        try {
            this.screen.startScreen();
            T t = dialog.get();
            return t;
        }
        finally {
            this.screen.stopScreen();
        }
    }

    @Override
    public List<File> renameAll(Map<File, File> renameMap, RenameAction renameAction, ConflictAction conflictAction, List<Match<File, ?>> matches) throws Exception {
        if (renameMap.isEmpty()) {
            return super.renameAll(renameMap, renameAction, conflictAction, matches);
        }
        String title = String.format("%s / %s", new Object[]{renameAction, conflictAction});
        int columnSize = renameMap.keySet().stream().mapToInt(f -> f.getName().length()).max().orElse(0);
        Function<Map.Entry, String> renderer = m -> String.format("%-" + columnSize + "s\t=>\t%s", ((File)m.getKey()).getName(), ((File)m.getValue()).getName());
        Predicate<Map.Entry> checked = m -> ((File)m.getKey()).exists() && !((File)m.getValue()).exists();
        List<Map.Entry> selection = this.showInputDialog(renameMap.entrySet(), renderer, checked, title);
        if (selection == null || selection.isEmpty()) {
            return Collections.emptyList();
        }
        return super.renameAll(selection.stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> a, LinkedHashMap::new)), renameAction, conflictAction, matches);
    }

    @Override
    protected <T extends SearchResult> List<T> selectSearchResult(String query, Collection<T> options, boolean sort, boolean alias, boolean strict, int limit) throws Exception {
        List<T> matches = MediaDetection.getProbableMatches(sort ? query : null, options, alias, false);
        if (matches.size() <= 1) {
            return matches;
        }
        SearchResult selection = (SearchResult)this.showInputDialog(matches, "Multiple Options", String.format("Select best match for \"%s\"", query));
        if (selection == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(selection);
    }

    public <T> T showInputDialog(Collection<T> options, String title, String message) throws Exception {
        return (T)this.onScreen(() -> {
            ListSelectDialogBuilder dialog = new ListSelectDialogBuilder();
            dialog.setExtraWindowHints(Collections.singleton(Window.Hint.CENTERED));
            dialog.setTitle(title);
            dialog.setDescription(message);
            options.forEach(dialog::addListItem);
            return ((ListSelectDialog)dialog.build()).showDialog(this.ui);
        });
    }

    public <T> List<T> showInputDialog(Collection<T> options, Function<T, String> renderer, Predicate<T> checked, String title) throws Exception {
        return this.onScreen(() -> {
            ArrayList selection = new ArrayList(options.size());
            BasicWindow dialog = new BasicWindow();
            dialog.setTitle(title);
            dialog.setHints(Arrays.asList(Window.Hint.MODAL, Window.Hint.CENTERED));
            CheckBoxList checkBoxList = new CheckBoxList();
            for (Object option : options) {
                checkBoxList.addItem(new CheckBoxListItem(option, (String)renderer.apply(option)), checked.test(option));
            }
            Button okButton = new Button(LocalizedString.OK.toString(), () -> {
                for (CheckBoxListItem it : checkBoxList.getCheckedItems()) {
                    selection.add(it.getValue());
                }
                dialog.close();
            });
            Button cancelButton = new Button(LocalizedString.Cancel.toString(), () -> dialog.close());
            Panel contentPane = new Panel();
            contentPane.setLayoutManager(new GridLayout(1));
            contentPane.addComponent((Component)checkBoxList.setLayoutData(GridLayout.createLayoutData(GridLayout.Alignment.BEGINNING, GridLayout.Alignment.BEGINNING, true, true, 1, 1)));
            contentPane.addComponent((Component)new Separator(Direction.HORIZONTAL).setLayoutData(GridLayout.createLayoutData(GridLayout.Alignment.FILL, GridLayout.Alignment.CENTER, true, false, 1, 1)));
            contentPane.addComponent((Component)Panels.grid(2, okButton, cancelButton).setLayoutData(GridLayout.createLayoutData(GridLayout.Alignment.END, GridLayout.Alignment.CENTER, false, false, 1, 1)));
            dialog.setComponent(contentPane);
            this.ui.addWindowAndWait(dialog);
            return selection;
        });
    }

    protected static class CheckBoxListItem<T> {
        private final T value;
        private final String label;

        public CheckBoxListItem(T value, String label) {
            this.value = value;
            this.label = label;
        }

        public T getValue() {
            return this.value;
        }

        public String toString() {
            return this.label;
        }
    }
}

