/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.cli;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Arrays;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.stream.Collectors;
import net.filebot.Resource;
import net.filebot.cli.ScriptProvider;
import net.filebot.util.ByteBufferOutputStream;

public class ScriptBundle
implements ScriptProvider {
    private Resource<byte[]> bundle;
    private Certificate certificate;

    public ScriptBundle(Resource<byte[]> bundle, InputStream certificate) throws CertificateException {
        this.bundle = bundle.memoize();
        this.certificate = CertificateFactory.getInstance("X.509").generateCertificate(certificate);
    }

    @Override
    public String getScript(String name) throws Exception {
        try (JarInputStream jar = new JarInputStream((InputStream)new ByteArrayInputStream(this.bundle.get()), true);){
            JarEntry f = jar.getNextJarEntry();
            while (f != null) {
                block20: {
                    ByteBufferOutputStream buffer;
                    block22: {
                        Certificate[] certificates;
                        block21: {
                            if (f.isDirectory() || !f.getName().startsWith(name) || !f.getName().substring(name.length()).equals(".groovy")) break block20;
                            buffer = new ByteBufferOutputStream(f.getSize() > 0L ? f.getSize() : 8192L);
                            buffer.transferFully(jar);
                            jar.closeEntry();
                            certificates = f.getCertificates();
                            if (certificates == null) break block21;
                            if (!Arrays.stream(f.getCertificates()).noneMatch(this.certificate::equals)) break block22;
                        }
                        throw new SecurityException("BAD certificate: " + Arrays.asList(certificates));
                    }
                    String string = StandardCharsets.UTF_8.decode(buffer.getByteBuffer()).toString();
                    return string;
                }
                f = jar.getNextJarEntry();
            }
        }
        throw new FileNotFoundException("Script not found: " + name);
    }

    public Map<String, String> getManifest() throws Exception {
        try (JarInputStream jar = new JarInputStream((InputStream)new ByteArrayInputStream(this.bundle.get()), true);){
            Map<String, String> map = jar.getManifest().getMainAttributes().entrySet().stream().collect(Collectors.toMap(it -> it.getKey().toString(), it -> it.getValue().toString()));
            return map;
        }
    }
}

