/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.cli;

import groovy.lang.GroovyClassLoader;
import java.util.Map;
import java.util.ResourceBundle;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import net.filebot.cli.CmdlineInterface;
import net.filebot.cli.ScriptProvider;
import net.filebot.util.RegularExpressions;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.codehaus.groovy.jsr223.GroovyScriptEngineImpl;
import org.codehaus.groovy.runtime.StackTraceUtils;

public class ScriptShell {
    public static final String ARGV_BINDING_NAME = "args";
    public static final String SHELL_BINDING_NAME = "__shell";
    public static final String SHELL_CLI_BINDING_NAME = "__cli";
    public static final String SHELL_ARGS_BINDING_NAME = "__args";
    private final ScriptEngine engine = this.createScriptEngine();
    private final ScriptProvider scriptProvider;

    public ScriptShell(ScriptProvider scriptProvider, CmdlineInterface cli, Map<String, ?> globals) throws ScriptException {
        this.scriptProvider = scriptProvider;
        Bindings bindings = this.engine.createBindings();
        bindings.putAll((Map<? extends String, ? extends Object>)globals);
        bindings.put(SHELL_BINDING_NAME, (Object)this);
        bindings.put(SHELL_CLI_BINDING_NAME, (Object)cli);
        this.engine.getContext().setBindings(bindings, 200);
    }

    public ScriptEngine createScriptEngine() {
        ResourceBundle bundle = ResourceBundle.getBundle(ScriptShell.class.getName());
        CompilerConfiguration config = new CompilerConfiguration();
        config.setScriptBaseClass(bundle.getString("scriptBaseClass"));
        ImportCustomizer imports = new ImportCustomizer();
        imports.addStarImports(RegularExpressions.COMMA.split(bundle.getString("starImport")));
        imports.addStaticStars(RegularExpressions.COMMA.split(bundle.getString("starStaticImport")));
        config.addCompilationCustomizers(imports);
        GroovyClassLoader classLoader = new GroovyClassLoader(Thread.currentThread().getContextClassLoader(), config);
        return new GroovyScriptEngineImpl(classLoader);
    }

    public Object evaluate(String script, Bindings bindings) throws Throwable {
        try {
            return this.engine.eval(script, bindings);
        }
        catch (Throwable e) {
            while (e.getClass() == ScriptException.class && e.getCause() != null) {
                e = e.getCause();
            }
            throw StackTraceUtils.deepSanitize(e);
        }
    }

    public Object runScript(String name, Bindings bindings) throws Throwable {
        return this.evaluate(this.scriptProvider.getScript(name), bindings);
    }
}

