/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.hash;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Scanner;
import net.filebot.Logging;
import net.filebot.hash.VerificationFormat;

public class VerificationFileReader
implements Iterator<Map.Entry<File, String>>,
Closeable {
    private final Scanner scanner;
    private final VerificationFormat format;
    private Map.Entry<File, String> buffer;
    private int lineNumber = 0;

    public VerificationFileReader(Readable source, VerificationFormat format) {
        this.scanner = new Scanner(source);
        this.format = format;
    }

    @Override
    public boolean hasNext() {
        if (this.buffer == null) {
            this.buffer = this.nextEntry();
        }
        return this.buffer != null;
    }

    @Override
    public Map.Entry<File, String> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        try {
            Map.Entry<File, String> entry = this.buffer;
            return entry;
        }
        finally {
            this.buffer = null;
        }
    }

    protected Map.Entry<File, String> nextEntry() {
        Object entry = null;
        while (entry == null && this.scanner.hasNextLine()) {
            String line = this.scanner.nextLine().trim();
            if (!this.isComment(line)) {
                try {
                    entry = this.format.parseObject(line);
                }
                catch (ParseException e) {
                    Logging.debug.warning(Logging.format("Illegal format on line %d: %s", this.lineNumber, line));
                }
            }
            ++this.lineNumber;
        }
        return entry;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    protected boolean isComment(String line) {
        return line.isEmpty() || line.startsWith(";");
    }

    @Override
    public void close() throws IOException {
        this.scanner.close();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

