/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.hash;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Date;
import net.filebot.Settings;
import net.filebot.hash.VerificationFormat;

public class VerificationFileWriter
implements Closeable {
    protected PrintWriter out;
    protected VerificationFormat format;

    public VerificationFileWriter(File file, VerificationFormat format, Charset charset) throws IOException {
        this(new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), charset)), false), format, charset);
    }

    public VerificationFileWriter(PrintWriter out, VerificationFormat format, Charset charset) {
        this.out = out;
        this.format = format;
        this.writeHeader(charset);
    }

    protected void writeHeader(Charset charset) {
        this.out.format("; Generated by %s %s on %tF at %<tT%n", Settings.getApplicationName(), Settings.getApplicationVersion(), new Date());
        this.out.format("; charset=%s%n", charset);
        this.out.format(";%n", new Object[0]);
    }

    public void write(String path, String hash) {
        this.out.format("%s%n", this.format.format(path, hash));
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

