/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.hash;

import java.io.File;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.AbstractMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VerificationFormat
extends Format {
    private final String hashTypeHint;
    private final Pattern pattern = Pattern.compile("^(\\p{XDigit}+)\\s+(?:\\?\\w+)?\\*?(.+)$");

    public VerificationFormat() {
        this.hashTypeHint = "";
    }

    public VerificationFormat(String hashTypeHint) {
        this.hashTypeHint = hashTypeHint.isEmpty() ? "" : '?' + hashTypeHint.toUpperCase();
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer sb, FieldPosition pos) {
        Map.Entry entry = (Map.Entry)obj;
        String path = ((File)entry.getKey()).getPath();
        String hash = (String)entry.getValue();
        return sb.append(this.format(path, hash));
    }

    public String format(String path, String hash) {
        return String.format("%s %s*%s", hash, this.hashTypeHint, path);
    }

    @Override
    public Map.Entry<File, String> parseObject(String line) throws ParseException {
        Matcher matcher = this.pattern.matcher(line);
        if (!matcher.find()) {
            throw new ParseException("Illegal input pattern", 0);
        }
        return this.entry(matcher.group(2), matcher.group(1));
    }

    @Override
    public Map.Entry<File, String> parseObject(String line, ParsePosition pos) {
        throw new UnsupportedOperationException();
    }

    protected Map.Entry<File, String> entry(String path, String hash) {
        return new AbstractMap.SimpleImmutableEntry<File, String>(new File(path), hash);
    }
}

