/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.media;

import java.io.File;
import java.io.FileFilter;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.filebot.Logging;
import net.filebot.MediaTypes;
import net.filebot.Settings;
import net.filebot.WebServices;
import net.filebot.format.ExpressionFormatMethods;
import net.filebot.media.MediaDetection;
import net.filebot.media.XattrMetaInfo;
import net.filebot.mediainfo.MediaInfo;
import net.filebot.similarity.NameSimilarityMetric;
import net.filebot.similarity.Normalization;
import net.filebot.util.FastFile;
import net.filebot.util.FileUtilities;
import net.filebot.util.StringUtilities;
import net.filebot.web.Episode;
import net.filebot.web.Movie;

public class AutoDetection {
    private File[] files;
    private Locale locale;
    private static final Pattern MOVIE_PATTERN = Pattern.compile("Movies", 2);
    private static final Pattern SERIES_PATTERN = Pattern.compile("TV.Shows|TV.Series|Season.[0-9]+", 2);
    private static final Pattern ANIME_PATTERN = Pattern.compile("Anime", 2);
    private static final Pattern EPISODE_PATTERN = Pattern.compile("E[P]?\\d{1,3}", 2);
    private static final Pattern SERIES_EPISODE_PATTERN = Pattern.compile("^tv[sp][ _.-]", 2);
    private static final Pattern ANIME_EPISODE_PATTERN = Pattern.compile("^\\[[^\\]]+Subs\\]", 2);
    private static final Pattern YEAR = Pattern.compile("\\D(?:19|20)\\d{2}\\D");
    private static final Pattern EPISODE_NUMBERS = Pattern.compile("\\b\\d{1,3}\\b");
    private static final Pattern DASH = Pattern.compile("^.{0,3}\\s[-]\\s.+$", 256);
    private static final Pattern NUMBER_PAIR = Pattern.compile("\\D\\d{1,2}\\D{1,3}\\d{1,2}\\D");
    private static final Pattern NON_NUMBER_NAME = Pattern.compile("^[\\p{L}\\p{Space}\\p{Punct}]+$", 256);

    public AutoDetection(Collection<File> root, boolean resolve, Locale locale) {
        this.files = (File[])(resolve ? this.resolve(root.stream().map(FastFile::new), MediaDetection.getSystemFilesFilter()) : root.stream()).toArray(File[]::new);
        this.locale = locale;
    }

    protected Stream<File> resolve(Stream<File> root, FileFilter excludes) {
        return root.flatMap(f -> {
            if (f.isHidden() || excludes.accept((File)f)) {
                return Stream.empty();
            }
            if (f.isFile()) {
                return Stream.of(f);
            }
            if (f.isDirectory()) {
                return MediaDetection.isDiskFolder(f) ? Stream.of(f) : this.resolve(FileUtilities.getChildren(f).stream(), excludes);
            }
            return Stream.empty();
        });
    }

    public List<File> getFiles() {
        return Collections.unmodifiableList(Arrays.asList(this.files));
    }

    public boolean isMusic(File f) {
        return MediaTypes.AUDIO_FILES.accept(f) && !MediaTypes.VIDEO_FILES.accept(f);
    }

    public boolean isMovie(File f) {
        return this.anyMatch(f.getParentFile(), MOVIE_PATTERN) || MediaDetection.isMovie(f, true);
    }

    public boolean isEpisode(File f) {
        if (MediaDetection.isEpisode(f.getName(), false) && (this.anyMatch(f.getParentFile(), SERIES_PATTERN) || StringUtilities.find(f.getName(), SERIES_EPISODE_PATTERN))) {
            return true;
        }
        if (MediaDetection.isEpisode(f.getPath(), true)) {
            return true;
        }
        Object metaInfo = XattrMetaInfo.xattr.getMetaInfo(f);
        return metaInfo instanceof Episode && !WebServices.AniDB.getIdentifier().equals(((Episode)metaInfo).getSeriesInfo().getDatabase());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isAnime(File f) {
        Object metaInfo;
        if (MediaDetection.parseEpisodeNumber(f.getName(), false) == null) {
            return false;
        }
        if (this.anyMatch(f.getParentFile(), ANIME_PATTERN)) return true;
        if (StringUtilities.find(f.getName(), ANIME_EPISODE_PATTERN)) return true;
        if (StringUtilities.find(f.getName(), Normalization.EMBEDDED_CHECKSUM)) {
            return true;
        }
        if (MediaTypes.VIDEO_FILES.accept(f) && f.length() > 1000000L) {
            try (MediaInfo mi = new MediaInfo().open(f);){
                long minutes = Duration.ofMillis(Long.parseLong(mi.get(MediaInfo.StreamKind.General, 0, "Duration"))).toMinutes();
                boolean bl = minutes < 60L || mi.get(MediaInfo.StreamKind.General, 0, "AudioLanguageList").contains("Japanese") && mi.get(MediaInfo.StreamKind.General, 0, "TextCodecList").contains("ASS");
                return bl;
            }
            catch (Exception e) {
                Logging.debug.warning("Failed to read audio language: " + e.getMessage());
            }
        }
        if (!((metaInfo = XattrMetaInfo.xattr.getMetaInfo(f)) instanceof Episode)) return false;
        if (!WebServices.AniDB.getIdentifier().equals(((Episode)metaInfo).getSeriesInfo().getDatabase())) return false;
        return true;
    }

    public boolean anyMatch(File file, Pattern pattern) {
        for (File f = file; f != null && !MediaDetection.isVolumeRoot(f); f = f.getParentFile()) {
            if (!pattern.matcher(f.getName()).matches()) continue;
            return true;
        }
        return false;
    }

    public Map<Group, Set<File>> group() {
        TreeMap<Group, Set<File>> groups = new TreeMap<Group, Set<File>>();
        ExecutorService workerThreadPool = Executors.newFixedThreadPool(Settings.getPreferredThreadPoolSize());
        try {
            Arrays.stream(this.files).collect(Collectors.toMap(f -> f, f -> workerThreadPool.submit(() -> this.detectGroup((File)f)))).forEach((file, group) -> {
                try {
                    groups.computeIfAbsent((Group)group.get(), k -> new TreeSet()).add(file);
                }
                catch (Exception e) {
                    Logging.debug.log(Level.SEVERE, e.getMessage(), e);
                }
            });
        }
        finally {
            workerThreadPool.shutdownNow();
        }
        return groups;
    }

    private Group detectGroup(File f) throws Exception {
        Group group = new Group();
        if (this.isMusic(f)) {
            return group.music(f);
        }
        if (this.isMovie(f)) {
            return group.movie(this.getMovieMatches(f, false));
        }
        if (this.isEpisode(f)) {
            return group.series(this.getSeriesMatches(f, false));
        }
        if (this.isAnime(f)) {
            return group.anime(this.getSeriesMatches(f, true));
        }
        if (StringUtilities.find(f.getName(), EPISODE_PATTERN)) {
            return group.series(this.getSeriesMatches(f, false));
        }
        List<Movie> m = this.getMovieMatches(f, false);
        List<String> s = this.getSeriesMatches(f, false);
        if (m.isEmpty() && s.isEmpty()) {
            return group;
        }
        if (s.size() > 0 && m.isEmpty()) {
            return group.series(s);
        }
        if (m.size() > 0 && s.isEmpty()) {
            return group.movie(m);
        }
        return new Rules(f, s, m).apply();
    }

    private List<String> getSeriesMatches(File f, boolean anime) throws Exception {
        List<File> episodes;
        List<String> names = MediaDetection.detectSeriesNames(Collections.singleton(f), anime, this.locale);
        if (names.isEmpty() && (episodes = this.getVideoFiles(f.getParentFile())).size() >= 5) {
            names = MediaDetection.detectSeriesNames(episodes, anime, this.locale);
        }
        return names;
    }

    private List<Movie> getMovieMatches(File file, boolean strict) throws Exception {
        return MediaDetection.detectMovie(file, WebServices.TheMovieDB, this.locale, strict);
    }

    private List<File> getVideoFiles(File parent) {
        return Arrays.stream(this.files).filter(it -> parent.equals(it.getParentFile())).filter(MediaTypes.VIDEO_FILES::accept).collect(Collectors.toList());
    }

    public static class Group
    extends EnumMap<Type, Object>
    implements Comparable<Group> {
        public Group() {
            super(Type.class);
        }

        public Object getMovie() {
            return this.get((Object)Type.Movie);
        }

        public Object getSeries() {
            return this.get((Object)Type.Series);
        }

        public Object getAnime() {
            return this.get((Object)Type.Anime);
        }

        public Object getMusic() {
            return this.get((Object)Type.Music);
        }

        public Group movie(List<Movie> movies) {
            this.put(Type.Movie, movies == null || movies.isEmpty() ? null : movies.get(0));
            return this;
        }

        public Group series(List<String> names) {
            this.put(Type.Series, names == null || names.isEmpty() ? null : Normalization.replaceSpace(Normalization.normalizePunctuation(names.get(0)).toLowerCase(), " ").trim());
            return this;
        }

        public Group anime(List<String> names) {
            this.put(Type.Anime, names == null || names.isEmpty() ? null : Normalization.replaceSpace(Normalization.normalizePunctuation(names.get(0)).toLowerCase(), " ").trim());
            return this;
        }

        public Group music(File f) {
            this.put(Type.Music, f == null ? null : f.getParent());
            return this;
        }

        public Type[] types() {
            return (Type[])this.entrySet().stream().filter(it -> it.getValue() != null).map(it -> (Type)((Object)((Object)it.getKey()))).toArray(Type[]::new);
        }

        @Override
        public int compareTo(Group other) {
            if (this.size() != other.size()) {
                return Integer.compare(this.size(), other.size());
            }
            return Arrays.stream(Type.values()).mapToInt(t -> Comparator.nullsLast(String.CASE_INSENSITIVE_ORDER).compare(Objects.toString(this.get(t), null), Objects.toString(other.get(t), null))).filter(i -> i != 0).findFirst().orElse(0);
        }
    }

    public static enum Type {
        Movie,
        Series,
        Anime,
        Music;

    }

    private static class Rule
    implements Test {
        public final int s;
        public final int m;
        private final Test t;

        public Rule(int s, int m, Test t) {
            this.s = s;
            this.m = m;
            this.t = t;
        }

        @Override
        public boolean test() throws Exception {
            return this.t.test();
        }
    }

    @FunctionalInterface
    private static interface Test {
        public boolean test() throws Exception;
    }

    private class Rules {
        private final Group group;
        private final File f;
        private final String s;
        private final Movie m;
        private final String dn;
        private final String fn;
        private final String sn;
        private final String mn;
        private final String my;
        private final String asn;
        private final Pattern snm;
        private final Pattern mnm;

        public Rules(File file, List<String> series, List<Movie> movie) throws Exception {
            this.group = new Group().series(series).movie(movie);
            this.f = file;
            this.s = series.get(0);
            this.m = movie.get(0);
            this.dn = this.normalize(FileUtilities.getName(MediaDetection.guessMovieFolder(this.f)));
            this.fn = this.normalize(FileUtilities.getName(this.f));
            this.sn = this.normalize(this.s);
            this.mn = this.normalize(this.m.getName());
            this.my = Integer.toString(this.m.getYear());
            this.snm = Pattern.compile(this.sn, 16);
            this.mnm = Pattern.compile(this.mn, 16);
            this.asn = StringUtilities.after(this.fn, this.snm).orElse(this.fn);
        }

        private String normalize(String self) {
            return self == null ? "" : Normalization.replaceSpace(Normalization.normalizePunctuation(ExpressionFormatMethods.ascii(self)).toLowerCase(), " ").trim();
        }

        private float getSimilarity(String self, String other) {
            return new NameSimilarityMetric().getSimilarity(self, other);
        }

        public Group apply() throws Exception {
            ArrayList<Rule> rules = new ArrayList<Rule>(15);
            rules.add(new Rule(-1, 0, this::equalsMovieName));
            rules.add(new Rule(-1, 0, this::containsMovieYear));
            rules.add(new Rule(-1, 0, this::containsMovieNameYear));
            rules.add(new Rule(5, -1, this::containsEpisodeNumbers));
            rules.add(new Rule(5, -1, this::commonNumberPattern));
            rules.add(new Rule(1, -1, this::episodeWithoutNumbers));
            rules.add(new Rule(1, -1, this::episodeNumbers));
            rules.add(new Rule(-1, 1, this::hasImdbId));
            rules.add(new Rule(-1, 1, this::nonNumberName));
            rules.add(new Rule(-1, 5, this::exactMovieMatch));
            rules.add(new Rule(-1, 1, this::containsMovieName));
            rules.add(new Rule(-1, 1, this::similarNameYear));
            rules.add(new Rule(-1, 1, this::similarNameNoNumbers));
            rules.add(new Rule(-1, 1, this::aliasNameMatch));
            int score_s = 0;
            int score_m = 0;
            for (Rule rule : rules) {
                if (!rule.test()) continue;
                if ((score_s += rule.s) >= 1 && (score_m += rule.m) <= -1) {
                    return this.group.movie(null);
                }
                if (score_m < 1 || score_s > -1) continue;
                return this.group.series(null);
            }
            return this.group;
        }

        public boolean equalsMovieName() {
            return this.mn.equals(this.fn);
        }

        public boolean containsMovieYear() {
            return this.m.getYear() >= 1950 && FileUtilities.listPathTail(this.f, 3, true).stream().anyMatch(it -> it.getName().contains(this.my) && MediaDetection.parseEpisodeNumber(it.getName(), false) == null);
        }

        public boolean containsMovieNameYear() {
            return this.mn.equals(this.sn) && Stream.of(this.dn, this.fn).anyMatch(it -> MediaDetection.parseEpisodeNumber(StringUtilities.after(it, YEAR).orElse(""), false) == null);
        }

        public boolean containsEpisodeNumbers() {
            return MediaDetection.parseEpisodeNumber(this.fn, true) != null || MediaDetection.parseDate(this.fn) != null;
        }

        public boolean commonNumberPattern() {
            return FileUtilities.getChildren(this.f.getParentFile(), MediaTypes.VIDEO_FILES, FileUtilities.HUMAN_NAME_ORDER).stream().filter(it -> StringUtilities.find(this.dn, this.snm) || StringUtilities.find(this.normalize(it.getName()), this.snm)).map(it -> StringUtilities.streamMatches(it.getName(), EPISODE_NUMBERS).map(Integer::new).collect(Collectors.toSet())).filter(it -> it.size() > 0).distinct().count() >= 10L;
        }

        public boolean episodeWithoutNumbers() throws Exception {
            return StringUtilities.find(this.asn, DASH) && AutoDetection.this.getMovieMatches(this.f, true).isEmpty();
        }

        public boolean episodeNumbers() throws Exception {
            String n = MediaDetection.stripReleaseInfo(this.asn, false);
            if (MediaDetection.parseEpisodeNumber(n, false) != null || NUMBER_PAIR.matcher(n).find()) {
                return Stream.of(this.dn, this.fn).anyMatch(it -> this.snm.matcher((CharSequence)it).find()) && AutoDetection.this.getMovieMatches(this.f, true).isEmpty();
            }
            return false;
        }

        public boolean hasImdbId() {
            return MediaDetection.grepImdbId(this.fn).size() > 0;
        }

        public boolean nonNumberName() {
            return StringUtilities.find(FileUtilities.getName(this.f), NON_NUMBER_NAME);
        }

        public boolean exactMovieMatch() throws Exception {
            return AutoDetection.this.getMovieMatches(this.f, true).size() > 0 && Stream.of(this.dn, this.fn).anyMatch(it -> StringUtilities.find(it, YEAR));
        }

        public boolean containsMovieName() {
            return this.fn.contains(this.mn) && MediaDetection.parseEpisodeNumber(StringUtilities.after(this.fn, this.mnm).orElse(this.fn), false) == null;
        }

        public boolean similarNameYear() {
            return this.getSimilarity(this.mn, this.fn) >= 0.8f || Stream.of(this.dn, this.fn).anyMatch(it -> StringUtilities.matchIntegers(it).stream().filter(y -> this.m.getYear() - 1 <= y && y <= this.m.getYear() + 1).count() > 0L);
        }

        public boolean similarNameNoNumbers() {
            return Stream.of(this.dn, this.fn).anyMatch(it -> StringUtilities.find(it, this.mnm) && !StringUtilities.find(StringUtilities.after(it, this.mnm).orElse((String)it), EPISODE_NUMBERS) && this.getSimilarity((String)it, this.mn) >= 0.2f + this.getSimilarity((String)it, this.sn));
        }

        public boolean aliasNameMatch() {
            return this.m.getEffectiveNamesWithoutYear().stream().map(this::normalize).anyMatch(this.fn::contains);
        }
    }
}

