/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.media;

import com.cedarsoftware.util.io.JsonReader;
import com.cedarsoftware.util.io.JsonWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.FileTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.filebot.MetaAttributeView;
import net.filebot.vfs.SimpleFileInfo;
import net.filebot.web.AudioTrack;
import net.filebot.web.Episode;
import net.filebot.web.Movie;
import net.filebot.web.MoviePart;
import net.filebot.web.MultiEpisode;

public class MetaAttributes {
    public static final String FILENAME_KEY = "net.filebot.filename";
    public static final String METADATA_KEY = "net.filebot.metadata";
    public static final Map<String, String> JSON_TYPE_MAP = Collections.unmodifiableMap(Stream.of(Episode.class, MultiEpisode.class, Movie.class, MoviePart.class, AudioTrack.class, SimpleFileInfo.class).collect(Collectors.toMap(Class::getName, Class::getSimpleName)));
    private final BasicFileAttributeView fileAttributeView;
    private final MetaAttributeView metaAttributeView;

    public MetaAttributes(File file) throws IOException {
        this.metaAttributeView = new MetaAttributeView(file);
        this.fileAttributeView = Files.getFileAttributeView(file.toPath(), BasicFileAttributeView.class, new LinkOption[0]);
    }

    public void setCreationDate(long millis) throws IOException {
        this.fileAttributeView.setTimes(null, null, FileTime.fromMillis(millis));
    }

    public long getCreationDate(long time) {
        try {
            return this.fileAttributeView.readAttributes().creationTime().toMillis();
        }
        catch (IOException e) {
            return 0L;
        }
    }

    public void setOriginalName(String name) {
        this.metaAttributeView.put(FILENAME_KEY, name);
    }

    public String getOriginalName() {
        return this.metaAttributeView.get(FILENAME_KEY);
    }

    public void setObject(Object object) {
        this.metaAttributeView.put(METADATA_KEY, MetaAttributes.toJson(object));
    }

    public Object getObject() {
        String json = this.metaAttributeView.get(METADATA_KEY);
        if (json != null && json.length() > 0) {
            return MetaAttributes.toObject(json);
        }
        return null;
    }

    public void clear() {
        this.metaAttributeView.put(FILENAME_KEY, null);
        this.metaAttributeView.put(METADATA_KEY, null);
    }

    public static String toJson(Object object) {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("TYPE_NAME_MAP", JSON_TYPE_MAP);
        options.put("SKIP_NULL", true);
        return JsonWriter.objectToJson(object, options);
    }

    public static Object toObject(String json) {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("TYPE_NAME_MAP", JSON_TYPE_MAP);
        return JsonReader.jsonToJava(json, options);
    }
}

