/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.media;

import java.io.File;
import java.io.FileFilter;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.text.Collator;
import java.text.Normalizer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.filebot.ApplicationFolder;
import net.filebot.Cache;
import net.filebot.CacheType;
import net.filebot.Resource;
import net.filebot.Settings;
import net.filebot.similarity.Normalization;
import net.filebot.util.FileUtilities;
import net.filebot.util.RegularExpressions;
import net.filebot.util.StringUtilities;
import net.filebot.util.SystemProperty;
import net.filebot.web.Movie;
import net.filebot.web.SearchResult;
import net.filebot.web.SubtitleSearchResult;
import org.tukaani.xz.XZInputStream;

public class ReleaseInfo {
    private String[] videoSources;
    private Pattern videoSourcePattern;
    private Pattern videoTagPattern;
    private Pattern languageTag;
    private Pattern categoryTag;
    private String[] categoryTags;
    private final Pattern[][] stopwords = new Pattern[2][];
    private final Pattern[][] blacklist = new Pattern[2][];
    private Set<File> volumeRoots;
    private Pattern structureRootFolderPattern;
    private static FolderEntryFilter diskFolderFilter;
    private static FileUtilities.RegexFileFilter diskFolderEntryFilter;
    private static ClutterFileFilter clutterFileFilter;
    private static FileUtilities.RegexFileFilter systemFilesFilter;
    private final Resource<Map<Pattern, String>> seriesMappings = this.resource("url.series-mappings", Cache.ONE_WEEK, Function.identity(), String[]::new).transform(lines -> {
        LinkedHashMap map = new LinkedHashMap(((String[])lines).length);
        Arrays.stream(lines).map(s -> RegularExpressions.TAB.split((CharSequence)s, 2)).filter(v -> ((String[])v).length == 2).forEach(v -> {
            Pattern pattern = Pattern.compile("(?<!\\p{Alnum})(" + v[0] + ")(?!\\p{Alnum})", 2);
            map.put(pattern, v[1]);
        });
        return Collections.unmodifiableMap(map);
    }).memoize();
    private final Resource<String[]> releaseGroup = this.lines("url.release-groups", Cache.ONE_WEEK);
    private final Resource<String[]> queryBlacklist = this.lines("url.query-blacklist", Cache.ONE_WEEK);
    private final Resource<SearchResult[]> tvdbIndex = this.tsv("url.thetvdb-index", Cache.ONE_WEEK, this::parseSeries, SearchResult[]::new);
    private final Resource<SearchResult[]> anidbIndex = this.tsv("url.anidb-index", Cache.ONE_WEEK, this::parseSeries, SearchResult[]::new);
    private final Resource<Movie[]> movieIndex = this.tsv("url.movie-list", Cache.ONE_MONTH, this::parseMovie, Movie[]::new);
    private final Resource<SubtitleSearchResult[]> osdbIndex = this.tsv("url.osdb-index", Cache.ONE_MONTH, this::parseSubtitle, SubtitleSearchResult[]::new);
    private final SystemProperty<Duration> refreshDuration = SystemProperty.of("url.refresh", Duration::parse);
    private Map<String, Locale> defaultLanguageMap;

    public String getVideoSource(String ... input) {
        if (this.videoSources == null || this.videoSourcePattern == null) {
            this.videoSources = RegularExpressions.PIPE.split(this.getProperty("pattern.video.source"));
            this.videoSourcePattern = this.getVideoSourcePattern();
        }
        return this.matchLast(this.videoSourcePattern, this.videoSources, input);
    }

    public List<String> getVideoTags(String ... input) {
        if (this.videoTagPattern == null) {
            this.videoTagPattern = this.getVideoTagPattern();
        }
        ArrayList<String> tags = new ArrayList<String>();
        for (String s : input) {
            if (s == null) continue;
            Matcher m = this.videoTagPattern.matcher(s);
            while (m.find()) {
                tags.add(m.group());
            }
        }
        return tags;
    }

    public String getStereoscopic3D(String ... input) {
        Pattern pattern = this.getStereoscopic3DPattern();
        for (String s : input) {
            Matcher m = pattern.matcher(s);
            if (!m.find()) continue;
            return m.group();
        }
        return null;
    }

    public String getReleaseGroup(String ... name) throws Exception {
        String[] groups = this.releaseGroup.get();
        String match = this.matchLast(this.getReleaseGroupPattern(true), groups, name);
        if (match != null) {
            return match;
        }
        return this.matchLast(this.getReleaseGroupPattern(false), groups, name);
    }

    public Locale getSubtitleLanguageTag(CharSequence ... name) {
        String lang;
        if (this.languageTag == null) {
            this.languageTag = this.getSubtitleLanguageTagPattern();
        }
        return (lang = this.matchLast(this.languageTag, null, name)) == null ? null : this.getDefaultLanguageMap().get(lang);
    }

    public String getSubtitleCategoryTag(CharSequence ... name) {
        if (this.categoryTag == null || this.categoryTags == null) {
            this.categoryTag = this.getSubtitleCategoryTagPattern();
            this.categoryTags = this.getSubtitleCategoryTags();
        }
        return this.matchLast(this.categoryTag, this.categoryTags, name);
    }

    protected String matchLast(Pattern pattern, String[] paragon, CharSequence ... sequence) {
        String lastMatch = null;
        for (CharSequence charSequence : sequence) {
            if (charSequence == null) continue;
            Matcher matcher = pattern.matcher(charSequence);
            while (matcher.find()) {
                lastMatch = matcher.group();
            }
        }
        if (lastMatch != null && paragon != null) {
            for (CharSequence charSequence : paragon) {
                lastMatch = Pattern.compile("(?<!\\p{Alnum})" + Pattern.quote((String)charSequence) + "(?!\\p{Alnum})", 258).matcher(lastMatch).replaceAll((String)charSequence);
            }
        }
        return lastMatch;
    }

    public List<String> cleanRelease(Collection<String> items, boolean strict) throws Exception {
        int b;
        int n = b = strict ? 1 : 0;
        if (this.stopwords[b] == null || this.blacklist[b] == null) {
            Pattern clutterBracket = this.getClutterBracketPattern(strict);
            Pattern releaseGroup = this.getReleaseGroupPattern(strict);
            Pattern releaseGroupTrim = this.getReleaseGroupTrimPattern();
            Pattern languageSuffix = this.getSubtitleLanguageTagPattern();
            Pattern languageTag = this.getLanguageTagPattern(strict);
            Pattern videoSource = this.getVideoSourcePattern();
            Pattern videoTags = this.getVideoTagPattern();
            Pattern videoFormat = this.getVideoFormatPattern(strict);
            Pattern stereoscopic3d = this.getStereoscopic3DPattern();
            Pattern resolution = this.getResolutionPattern();
            Pattern queryBlacklist = this.getBlacklistPattern();
            this.stopwords[b] = new Pattern[]{languageSuffix, languageTag, videoSource, videoTags, videoFormat, resolution, stereoscopic3d};
            this.blacklist[b] = new Pattern[]{Normalization.EMBEDDED_CHECKSUM, languageSuffix, releaseGroupTrim, queryBlacklist, languageTag, clutterBracket, releaseGroup, videoSource, videoTags, videoFormat, resolution, stereoscopic3d};
        }
        return items.stream().map(it -> {
            String head = strict ? this.clean((String)it, this.stopwords[b]) : this.substringBefore((String)it, this.stopwords[b]);
            String norm = Normalization.normalizePunctuation(this.clean(head, this.blacklist[b]));
            return norm;
        }).filter(s -> s.length() > 0).collect(Collectors.toList());
    }

    public String clean(String item, Pattern ... blacklisted) {
        for (Pattern it : blacklisted) {
            item = it.matcher(item).replaceAll("");
        }
        return item;
    }

    public String substringBefore(String item, Pattern ... stopwords) {
        for (Pattern it : stopwords) {
            String substring;
            Matcher matcher = it.matcher(item);
            if (!matcher.find() || Normalization.normalizePunctuation(substring = item.substring(0, matcher.start())).length() < 3) continue;
            item = substring;
        }
        return item;
    }

    public Set<File> getVolumeRoots() {
        if (this.volumeRoots == null) {
            HashSet<File> volumes = new HashSet<File>();
            File home = ApplicationFolder.UserHome.get();
            List<File> roots = FileUtilities.getFileSystemRoots();
            volumes.add(home);
            volumes.addAll(roots);
            if (File.separator.equals("/")) {
                for (File root : roots) {
                    volumes.addAll(FileUtilities.getChildren(root, FileUtilities.FOLDERS));
                }
                for (File mediaRoot : this.getMediaRoots()) {
                    volumes.addAll(FileUtilities.getChildren(mediaRoot, FileUtilities.FOLDERS));
                    volumes.add(mediaRoot);
                }
            }
            if (Settings.isMacSandbox()) {
                for (File userFolder : FileUtilities.getChildren(new File(System.getProperty("user.home")), FileUtilities.FOLDERS)) {
                    volumes.add(new File(home, userFolder.getName()));
                }
            } else {
                volumes.addAll(FileUtilities.getChildren(home, FileUtilities.FOLDERS));
            }
            this.volumeRoots = Collections.unmodifiableSet(volumes);
        }
        return this.volumeRoots;
    }

    public Pattern getStructureRootPattern() throws Exception {
        if (this.structureRootFolderPattern == null) {
            ArrayList<String> folders = new ArrayList<String>();
            for (String it : this.queryBlacklist.get()) {
                if (!it.startsWith("^") || !it.endsWith("$")) continue;
                folders.add(it);
            }
            this.structureRootFolderPattern = Pattern.compile(this.or(folders.toArray()), 2);
        }
        return this.structureRootFolderPattern;
    }

    public Pattern getLanguageTagPattern(boolean strict) {
        if (strict) {
            return Pattern.compile("(?<=[-\\[\\{\\(])" + this.or(this.quoteAll(this.getDefaultLanguageMap().keySet())) + "(?=[-\\]\\}\\)]|$)", 2);
        }
        List<String> allCapsLanguageTags = this.getDefaultLanguageMap().keySet().stream().map(String::toUpperCase).collect(Collectors.toList());
        return Pattern.compile("(?<!\\p{Alnum})" + this.or(this.quoteAll(allCapsLanguageTags)) + "(?!\\p{Alnum})");
    }

    public Pattern getSubtitleCategoryTagPattern() {
        return Pattern.compile("(?<=[._-](" + this.or(this.quoteAll(this.getDefaultLanguageMap().keySet())) + ")[._-])" + this.or(this.getSubtitleCategoryTags()) + "$", 2);
    }

    public Pattern getSubtitleLanguageTagPattern() {
        return Pattern.compile("(?<=[._-])" + this.or(this.quoteAll(this.getDefaultLanguageMap().keySet())) + "(?=([._-]" + this.or(this.getSubtitleCategoryTags()) + ")?$)", 2);
    }

    public Pattern getResolutionPattern() {
        return Pattern.compile("(?<!\\p{Alnum})(\\d{4}|[6-9]\\d{2})x(\\d{4}|[4-9]\\d{2})(?!\\p{Alnum})");
    }

    public Pattern getVideoFormatPattern(boolean strict) {
        String pattern = this.getProperty("pattern.video.format");
        return strict ? this.compileWordPattern(pattern) : Pattern.compile(pattern, 2);
    }

    public Pattern getVideoSourcePattern() {
        return this.compileWordPattern(this.getProperty("pattern.video.source"));
    }

    public Pattern getVideoTagPattern() {
        return this.compileWordPattern(this.getProperty("pattern.video.tags"));
    }

    public Pattern getStereoscopic3DPattern() {
        return this.compileWordPattern(this.getProperty("pattern.video.s3d"));
    }

    public Pattern getRepackPattern() {
        return this.compileWordPattern(this.getProperty("pattern.video.repack"));
    }

    public Pattern getExcludePattern() {
        return this.compileWordPattern(this.getProperty("pattern.clutter.excludes"));
    }

    public Pattern getClutterBracketPattern(boolean strict) {
        String brackets = "()[]{}";
        String contains = strict ? "[[^a-z0-9]&&[^" + Pattern.quote(brackets) + "]]" : "\\p{Alpha}";
        return IntStream.range(0, brackets.length() / 2).map(i -> i * 2).mapToObj(i -> {
            String open = Pattern.quote(brackets.substring(i, i + 1));
            String close = Pattern.quote(brackets.substring(i + 1, i + 2));
            String notOpenClose = "[^" + open + close + "]+?";
            return open + "(" + notOpenClose + contains + notOpenClose + ")" + close;
        }).collect(Collectors.collectingAndThen(Collectors.joining("|"), pattern -> Pattern.compile(pattern, 2)));
    }

    public Pattern getReleaseGroupPattern(boolean strict) throws Exception {
        String group = "((?<!\\p{Alnum})" + this.or(this.releaseGroup.get()) + "(?!\\p{Alnum})[\\p{Punct}]??)+";
        Object[] groupHeadTail = new String[]{"(?<=^[\\P{Alnum}]*)" + group, group + "(?=[\\P{Alnum}]*$)"};
        return Pattern.compile(this.or(groupHeadTail), strict ? 0 : 2);
    }

    public Pattern getReleaseGroupTrimPattern() throws Exception {
        return Pattern.compile("(?<=\\[|\\(|^)" + this.or(this.releaseGroup.get()) + "(?=\\]|\\)|\\-)|(?<=\\[|\\(|\\-)" + this.or(this.releaseGroup.get()) + "(?=\\]|\\)|$)", 2);
    }

    public Pattern getBlacklistPattern() throws Exception {
        return this.compileWordPattern(this.queryBlacklist.get());
    }

    private Pattern compileWordPattern(String[] patterns) {
        return Pattern.compile("(?<!\\p{Alnum})" + this.or(patterns) + "(?!\\p{Alnum})", 2);
    }

    private Pattern compileWordPattern(String pattern) {
        return Pattern.compile("(?<!\\p{Alnum})(" + pattern + ")(?!\\p{Alnum})", 2);
    }

    public Map<Pattern, String> getSeriesMappings() throws Exception {
        return this.seriesMappings.get();
    }

    public SearchResult[] getTheTVDBIndex() throws Exception {
        return this.tvdbIndex.get();
    }

    public SearchResult[] getAnidbIndex() throws Exception {
        return this.anidbIndex.get();
    }

    public Movie[] getMovieList() throws Exception {
        return this.movieIndex.get();
    }

    public SubtitleSearchResult[] getOpenSubtitlesIndex() throws Exception {
        return this.osdbIndex.get();
    }

    public FileFilter getDiskFolderFilter() {
        if (diskFolderFilter == null) {
            diskFolderFilter = new FolderEntryFilter(Pattern.compile(this.getProperty("pattern.diskfolder.entry")));
        }
        return diskFolderFilter;
    }

    public FileFilter getDiskFolderEntryFilter() {
        if (diskFolderEntryFilter == null) {
            diskFolderEntryFilter = new FileUtilities.RegexFileFilter(Pattern.compile(this.getProperty("pattern.diskfolder.entry")));
        }
        return diskFolderEntryFilter;
    }

    public FileFilter getClutterFileFilter() {
        if (clutterFileFilter == null) {
            clutterFileFilter = new ClutterFileFilter(this.getExcludePattern(), Long.parseLong(this.getProperty("number.clutter.maxfilesize")));
        }
        return clutterFileFilter;
    }

    public FileFilter getSystemFilesFilter() {
        if (systemFilesFilter == null) {
            systemFilesFilter = new FileUtilities.RegexFileFilter(Pattern.compile(this.getProperty("pattern.system.files"), 2));
        }
        return systemFilesFilter;
    }

    public List<File> getMediaRoots() {
        String roots = this.getProperty("folder.media.roots");
        return RegularExpressions.COMMA.splitAsStream(roots).map(File::new).collect(Collectors.toList());
    }

    public String[] getSubtitleCategoryTags() {
        String tags = this.getProperty("pattern.subtitle.tags");
        return RegularExpressions.PIPE.split(tags);
    }

    private SearchResult parseSeries(String[] v) {
        int id = Integer.parseInt(v[0]);
        String name = v[1];
        String[] aliasNames = Arrays.copyOfRange(v, 2, v.length);
        return new SearchResult(id, name, aliasNames);
    }

    private Movie parseMovie(String[] v) {
        int imdbid = Integer.parseInt(v[0]);
        int tmdbid = Integer.parseInt(v[1]);
        int year = Integer.parseInt(v[2]);
        String name = v[3];
        String[] aliasNames = Arrays.copyOfRange(v, 4, v.length);
        return new Movie(name, aliasNames, year, imdbid > 0 ? imdbid : -1, tmdbid > 0 ? tmdbid : -1, null);
    }

    private SubtitleSearchResult parseSubtitle(String[] v) {
        String kind = v[0];
        int score = Integer.parseInt(v[1]);
        int imdbId = Integer.parseInt(v[2]);
        int year = Integer.parseInt(v[3]);
        String name = v[4];
        String[] aliasNames = Arrays.copyOfRange(v, 5, v.length);
        return new SubtitleSearchResult(name, aliasNames, year, imdbId, -1, Locale.ENGLISH, SubtitleSearchResult.Kind.forName(kind), score);
    }

    protected Resource<String[]> lines(String name, Duration expirationTime) {
        return this.resource(name, expirationTime, Function.identity(), String[]::new).memoize();
    }

    protected <A> Resource<A[]> tsv(String name, Duration expirationTime, Function<String[], A> parse, IntFunction<A[]> generator) {
        return this.resource(name, expirationTime, s -> parse.apply(RegularExpressions.TAB.split((CharSequence)s)), generator).memoize();
    }

    protected <A> Resource<A[]> resource(String name, Duration expirationTime, Function<String, A> parse, IntFunction<A[]> generator) {
        return () -> {
            Cache cache = Cache.getCache("data", CacheType.Persistent);
            byte[] bytes = cache.bytes(name, n -> new URL(this.getProperty((String)n)), XZInputStream::new).expire(this.refreshDuration.optional().orElse(expirationTime)).get();
            Stream<String> lines = RegularExpressions.NEWLINE.splitAsStream(StandardCharsets.UTF_8.decode(ByteBuffer.wrap(bytes)));
            return lines.filter(s -> s.length() > 0).map(parse).filter(Objects::nonNull).toArray(generator);
        };
    }

    protected String getProperty(String name) {
        return System.getProperty(name, ResourceBundle.getBundle(ReleaseInfo.class.getName()).getString(name));
    }

    private String or(Object[] terms) {
        return StringUtilities.join(Arrays.stream(terms).sorted(Collections.reverseOrder()), "|", "(", ")");
    }

    private String[] quoteAll(Collection<String> values) {
        return (String[])values.stream().map(s -> Pattern.quote(s)).toArray(String[]::new);
    }

    public Map<String, Locale> getDefaultLanguageMap() {
        if (this.defaultLanguageMap == null) {
            this.defaultLanguageMap = this.getLanguageMap(Locale.ENGLISH, Locale.getDefault());
        }
        return this.defaultLanguageMap;
    }

    public Map<String, Locale> getLanguageMap(Locale ... displayLanguages) {
        displayLanguages = (Locale[])Arrays.stream(displayLanguages).distinct().toArray(Locale[]::new);
        Collator collator = Collator.getInstance(Locale.ENGLISH);
        collator.setDecomposition(2);
        collator.setStrength(0);
        TreeMap<Object, Locale> languageMap = new TreeMap<Object, Locale>(collator);
        for (String code : Locale.getISOLanguages()) {
            Locale locale = new Locale(code);
            Locale iso3locale = new Locale(locale.getISO3Language());
            languageMap.put(locale.getLanguage(), iso3locale);
            languageMap.put(locale.getISO3Language(), iso3locale);
            for (Locale language : displayLanguages) {
                String languageName = Normalizer.normalize(locale.getDisplayLanguage(language), Normalizer.Form.NFKD);
                languageMap.put(languageName.toLowerCase(), iso3locale);
            }
        }
        Locale brazil = new Locale("pob");
        languageMap.put("brazilian", brazil);
        languageMap.put("pb", brazil);
        languageMap.put("pob", brazil);
        languageMap.put("tib", new Locale("bod"));
        languageMap.put("cze", new Locale("ces"));
        languageMap.put("wel", new Locale("cym"));
        languageMap.put("ger", new Locale("deu"));
        languageMap.put("gre", new Locale("ell"));
        languageMap.put("baq", new Locale("eus"));
        languageMap.put("per", new Locale("fas"));
        languageMap.put("fre", new Locale("fra"));
        languageMap.put("arm", new Locale("hye"));
        languageMap.put("ice", new Locale("isl"));
        languageMap.put("geo", new Locale("kat"));
        languageMap.put("mac", new Locale("mkd"));
        languageMap.put("mao", new Locale("mri"));
        languageMap.put("may", new Locale("msa"));
        languageMap.put("bur", new Locale("mya"));
        languageMap.put("dut", new Locale("nld"));
        languageMap.put("rum", new Locale("ron"));
        languageMap.put("slo", new Locale("slk"));
        languageMap.put("alb", new Locale("sqi"));
        languageMap.put("chi", new Locale("zho"));
        languageMap.remove("");
        languageMap.remove("II");
        languageMap.remove("III");
        languageMap.remove("hi");
        return Collections.unmodifiableMap(languageMap);
    }

    public static class ClutterFileFilter
    extends FileFolderNameFilter {
        private long maxFileSize;

        public ClutterFileFilter(Pattern namePattern, long maxFileSize) {
            super(namePattern);
            this.maxFileSize = maxFileSize;
        }

        @Override
        public boolean accept(File file) {
            return super.accept(file) && file.isFile() && file.length() < this.maxFileSize;
        }
    }

    public static class FileFolderNameFilter
    implements FileFilter {
        private final Pattern namePattern;

        public FileFolderNameFilter(Pattern namePattern) {
            this.namePattern = namePattern;
        }

        @Override
        public boolean accept(File file) {
            return this.namePattern.matcher(file.getName()).find() || file.isFile() && this.namePattern.matcher(file.getParentFile().getName()).find();
        }
    }

    public static class FolderEntryFilter
    implements FileFilter {
        private final Pattern entryPattern;

        public FolderEntryFilter(Pattern entryPattern) {
            this.entryPattern = entryPattern;
        }

        @Override
        public boolean accept(File dir) {
            return FileUtilities.getChildren(dir, f -> this.entryPattern.matcher(f.getName()).matches()).size() > 0;
        }
    }
}

