/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.media;

import java.io.File;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.Icon;
import net.filebot.ResourceManager;
import net.filebot.media.XattrMetaInfo;
import net.filebot.web.Datasource;

public class XattrMetaInfoProvider
implements Datasource {
    @Override
    public String getIdentifier() {
        return "xattr";
    }

    @Override
    public String getName() {
        return "Extended Attributes";
    }

    @Override
    public Icon getIcon() {
        return ResourceManager.getIcon("search.xattr");
    }

    public Map<File, Object> match(Collection<File> files, boolean strict) {
        XattrMetaInfo xattr = new XattrMetaInfo(true, false);
        LinkedHashMap<File, Object> result = new LinkedHashMap<File, Object>();
        for (File f : files) {
            Object object = xattr.getMetaInfo(f);
            if (object != null) {
                result.put(f, object);
                continue;
            }
            if (strict) continue;
            result.put(f, f);
        }
        return result;
    }
}

