/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.mediainfo;

import com.drew.imaging.ImageMetadataReader;
import com.drew.imaging.ImageProcessingException;
import com.drew.lang.GeoLocation;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.Tag;
import com.drew.metadata.exif.ExifIFD0Directory;
import com.drew.metadata.exif.GpsDirectory;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URL;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.filebot.Cache;
import net.filebot.CacheType;
import net.filebot.Logging;
import net.filebot.util.FileUtilities;
import net.filebot.util.JsonUtilities;

public class ImageMetadata {
    private final Metadata metadata;
    public static final FileFilter SUPPORTED_FILE_TYPES = new FileUtilities.ExtensionFileFilter("jpg", "jpeg", "png", "webp", "gif", "ico", "bmp", "tif", "tiff", "psd", "pcx", "raw", "crw", "cr2", "nef", "orf", "raf", "rw2", "rwl", "srw", "arw", "dng", "x3f", "mov", "mp4", "m4v", "3g2", "3gp", "3gp");

    public ImageMetadata(File file) throws ImageProcessingException, IOException {
        if (!SUPPORTED_FILE_TYPES.accept(file)) {
            throw new IllegalArgumentException("Image type not supported: " + file);
        }
        this.metadata = ImageMetadataReader.readMetadata(file);
    }

    public Map<String, String> snapshot() {
        return this.snapshot(Tag::getTagName);
    }

    public Map<String, String> snapshot(Function<Tag, String> key) {
        return this.snapshot(key, d -> Stream.of("JPEG", "JFIF", "Interoperability", "Huffman", "File").noneMatch(d.getName()::equals));
    }

    public Map<String, String> snapshot(Function<Tag, String> key, Predicate<Directory> accept) {
        LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
        for (Directory directory : this.metadata.getDirectories()) {
            if (!accept.test(directory)) continue;
            for (Tag tag : directory.getTags()) {
                String v = tag.getDescription();
                if (v == null || v.length() <= 0) continue;
                values.put(key.apply(tag), v);
            }
        }
        return values;
    }

    public Optional<ZonedDateTime> getDateTaken() {
        return this.extract(m -> m.getFirstDirectoryOfType(ExifIFD0Directory.class)).map(d -> d.getDate(306)).map(d -> d.toInstant().atZone(ZoneOffset.UTC));
    }

    public Optional<Map<CameraProperty, String>> getCameraModel() {
        return this.extract(m -> m.getFirstDirectoryOfType(ExifIFD0Directory.class)).map(d -> {
            String maker = d.getDescription(271);
            String model = d.getDescription(272);
            EnumMap<CameraProperty, String> camera = new EnumMap<CameraProperty, String>(CameraProperty.class);
            if (maker != null) {
                camera.put(CameraProperty.maker, maker);
            }
            if (model != null) {
                camera.put(CameraProperty.model, model);
            }
            return camera;
        }).filter(m -> !m.isEmpty());
    }

    public Optional<Map<AddressComponent, String>> getLocationTaken() {
        return this.extract(m -> m.getFirstDirectoryOfType(GpsDirectory.class)).map(GpsDirectory::getGeoLocation).map(this::locate);
    }

    protected Map<AddressComponent, String> locate(GeoLocation location) {
        try {
            Cache cache = Cache.getCache("geocode", CacheType.Persistent);
            Object json = cache.json(location.getLatitude() + "," + location.getLongitude(), p -> new URL("https://maps.googleapis.com/maps/api/geocode/json?latlng=" + p)).get();
            EnumMap<AddressComponent, String> address = new EnumMap<AddressComponent, String>(AddressComponent.class);
            JsonUtilities.streamJsonObjects(json, "results").limit(1L).forEach(r -> JsonUtilities.streamJsonObjects(r, "address_components").forEach(a -> {
                String name = JsonUtilities.getString(a, "long_name");
                if (name != null) {
                    for (Object type : JsonUtilities.getArray(a, "types")) {
                        Arrays.stream(AddressComponent.values()).filter(c -> c.name().equals(type)).findFirst().ifPresent(c -> address.putIfAbsent((AddressComponent)((Object)c), name));
                    }
                }
            }));
            return address;
        }
        catch (Exception e) {
            Logging.debug.warning(e::toString);
            return null;
        }
    }

    public <T> Optional<T> extract(Function<Metadata, T> extract) {
        try {
            return Optional.ofNullable(extract.apply(this.metadata));
        }
        catch (Exception e) {
            Logging.debug.finest(Logging.format("Failed to extract image metadata: %s", e));
            return Optional.empty();
        }
    }

    public static enum AddressComponent {
        country,
        administrative_area_level_1,
        administrative_area_level_2,
        administrative_area_level_3,
        administrative_area_level_4,
        sublocality,
        neighborhood,
        route;

    }

    public static enum CameraProperty {
        maker,
        model;

    }
}

