/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.mediainfo;

import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.filebot.Logging;
import net.filebot.mediainfo.ImageMetadata;
import net.filebot.mediainfo.MediaInfoException;
import net.filebot.mediainfo.MediaInfoLibrary;
import net.filebot.util.RegularExpressions;

public class MediaInfo
implements Closeable {
    private Pointer handle;

    public MediaInfo() {
        try {
            this.handle = MediaInfoLibrary.INSTANCE.New();
        }
        catch (LinkageError e) {
            throw new MediaInfoException(e);
        }
    }

    public synchronized MediaInfo open(File file) throws IOException, IllegalArgumentException {
        if (!file.isFile() || file.length() < 65536L) {
            throw new IllegalArgumentException("Invalid media file: " + file);
        }
        String path = file.getCanonicalPath();
        if (Platform.isMac() && !StandardCharsets.US_ASCII.newEncoder().canEncode(path)) {
            Throwable throwable = null;
            try (RandomAccessFile raf = new RandomAccessFile(file, "r");){
                if (this.openViaBuffer(raf)) {
                    MediaInfo mediaInfo = this;
                    return mediaInfo;
                }
                try {
                    throw new IOException("Failed to initialize media info buffer: " + path);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
        if (0 != MediaInfoLibrary.INSTANCE.Open(this.handle, new WString(path))) {
            return this;
        }
        throw new IOException("Failed to open media file: " + path);
    }

    private boolean openViaBuffer(RandomAccessFile f) throws IOException {
        int result;
        byte[] buffer = new byte[0x400000];
        int read = -1;
        if (0 == MediaInfoLibrary.INSTANCE.Open_Buffer_Init(this.handle, f.length(), 0L)) {
            return false;
        }
        while (((result = MediaInfoLibrary.INSTANCE.Open_Buffer_Continue(this.handle, buffer, read = f.read(buffer))) & 8) != 8) {
            long gotoPos = MediaInfoLibrary.INSTANCE.Open_Buffer_Continue_GoTo_Get(this.handle);
            if (gotoPos >= 0L) {
                f.seek(gotoPos);
                MediaInfoLibrary.INSTANCE.Open_Buffer_Init(this.handle, f.length(), gotoPos);
            }
            if (read > 0) continue;
        }
        MediaInfoLibrary.INSTANCE.Open_Buffer_Finalize(this.handle);
        return true;
    }

    public synchronized String inform() {
        return MediaInfoLibrary.INSTANCE.Inform(this.handle).toString();
    }

    public String option(String option) {
        return this.option(option, "");
    }

    public synchronized String option(String option, String value) {
        return MediaInfoLibrary.INSTANCE.Option(this.handle, new WString(option), new WString(value)).toString();
    }

    public String get(StreamKind streamKind, int streamNumber, String parameter) {
        return this.get(streamKind, streamNumber, parameter, InfoKind.Text, InfoKind.Name);
    }

    public String get(StreamKind streamKind, int streamNumber, String parameter, InfoKind infoKind) {
        return this.get(streamKind, streamNumber, parameter, infoKind, InfoKind.Name);
    }

    public synchronized String get(StreamKind streamKind, int streamNumber, String parameter, InfoKind infoKind, InfoKind searchKind) {
        return MediaInfoLibrary.INSTANCE.Get(this.handle, streamKind.ordinal(), streamNumber, new WString(parameter), infoKind.ordinal(), searchKind.ordinal()).toString();
    }

    public String get(StreamKind streamKind, int streamNumber, int parameterIndex) {
        return this.get(streamKind, streamNumber, parameterIndex, InfoKind.Text);
    }

    public synchronized String get(StreamKind streamKind, int streamNumber, int parameterIndex, InfoKind infoKind) {
        return MediaInfoLibrary.INSTANCE.GetI(this.handle, streamKind.ordinal(), streamNumber, parameterIndex, infoKind.ordinal()).toString();
    }

    public synchronized int streamCount(StreamKind streamKind) {
        return MediaInfoLibrary.INSTANCE.Count_Get(this.handle, streamKind.ordinal(), -1);
    }

    public synchronized int parameterCount(StreamKind streamKind, int streamNumber) {
        return MediaInfoLibrary.INSTANCE.Count_Get(this.handle, streamKind.ordinal(), streamNumber);
    }

    public Map<StreamKind, List<Map<String, String>>> snapshot() {
        EnumMap<StreamKind, List<Map<String, String>>> mediaInfo = new EnumMap<StreamKind, List<Map<String, String>>>(StreamKind.class);
        for (StreamKind streamKind : StreamKind.values()) {
            int streamCount = this.streamCount(streamKind);
            if (streamCount <= 0) continue;
            ArrayList<Map<String, String>> streamInfoList = new ArrayList<Map<String, String>>(streamCount);
            for (int i = 0; i < streamCount; ++i) {
                streamInfoList.add(this.snapshot(streamKind, i));
            }
            mediaInfo.put(streamKind, streamInfoList);
        }
        return mediaInfo;
    }

    public Map<String, String> snapshot(StreamKind streamKind, int streamNumber) {
        LinkedHashMap<String, String> streamInfo = new LinkedHashMap<String, String>();
        int count = this.parameterCount(streamKind, streamNumber);
        for (int i = 0; i < count; ++i) {
            String value = this.get(streamKind, streamNumber, i, InfoKind.Text);
            if (value.length() <= 0) continue;
            streamInfo.put(this.get(streamKind, streamNumber, i, InfoKind.Name), value);
        }
        if (streamKind == StreamKind.Image && streamNumber == 0) {
            String path = this.get(StreamKind.General, 0, "CompleteName");
            try {
                Map<String, String> values = new ImageMetadata(new File(path)).snapshot(t -> Stream.of(t.getDirectoryName(), t.getTagName()).flatMap(RegularExpressions.NON_WORD::splitAsStream).distinct().collect(Collectors.joining("_")));
                streamInfo.putAll(values);
            }
            catch (Throwable e) {
                Logging.debug.warning(Logging.format("%s: %s", e, path));
            }
        }
        return streamInfo;
    }

    @Override
    public synchronized void close() {
        MediaInfoLibrary.INSTANCE.Close(this.handle);
    }

    public synchronized void dispose() {
        if (this.handle == null) {
            return;
        }
        MediaInfoLibrary.INSTANCE.Delete(this.handle);
        this.handle = null;
    }

    protected void finalize() {
        this.dispose();
    }

    public static String version() {
        return MediaInfo.staticOption("Info_Version");
    }

    public static String parameters() {
        return MediaInfo.staticOption("Info_Parameters");
    }

    public static String codecs() {
        return MediaInfo.staticOption("Info_Codecs");
    }

    public static String capacities() {
        return MediaInfo.staticOption("Info_Capacities");
    }

    public static String staticOption(String option) {
        return MediaInfo.staticOption(option, "");
    }

    public static String staticOption(String option, String value) {
        try {
            return MediaInfoLibrary.INSTANCE.Option(null, new WString(option), new WString(value)).toString();
        }
        catch (LinkageError e) {
            throw new MediaInfoException(e);
        }
    }

    public static Map<StreamKind, List<Map<String, String>>> snapshot(File file) throws IOException {
        try (MediaInfo mi = new MediaInfo().open(file);){
            Map<StreamKind, List<Map<String, String>>> map = mi.snapshot();
            return map;
        }
    }

    public static enum InfoKind {
        Name,
        Text,
        Measure,
        Options,
        Name_Text,
        Measure_Text,
        Info,
        HowTo,
        Domain;

    }

    public static enum StreamKind {
        General,
        Video,
        Audio,
        Text,
        Chapters,
        Image,
        Menu;

    }
}

